/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.udp.UdpConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOMessageAdapter;

public class UdpMessageReceiver
extends AbstractMessageReceiver
implements Work {
    protected DatagramSocket socket = null;
    protected InetAddress inetAddress;
    protected int bufferSize;
    private URI uri;

    public UdpMessageReceiver(AbstractConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        this.create(connector, component, endpoint);
        this.bufferSize = ((UdpConnector)connector).getBufferSize();
        this.uri = endpoint.getEndpointURI().getUri();
        try {
            this.inetAddress = InetAddress.getByName(this.uri.getHost());
        }
        catch (UnknownHostException e) {
            throw new InitialisationException(new Message("udp", 2, (Object)this.uri), e, this);
        }
        this.connect(this.uri);
        try {
            this.getWorkManager().scheduleWork(this, Long.MAX_VALUE, null, null);
        }
        catch (WorkException e) {
            throw new InitialisationException(new Message(151), e, this);
        }
    }

    protected void connect(URI uri) throws InitialisationException {
        this.logger.info((Object)("Attempting to connect to: " + uri.toString()));
        int count = ((UdpConnector)this.connector).getRetryCount();
        long freq = ((UdpConnector)this.connector).getRetryFrequency();
        ++count;
        for (int i = 0; i < count; ++i) {
            try {
                this.socket = this.createSocket(uri, this.inetAddress);
                this.socket.setSoTimeout(((UdpConnector)this.connector).getTimeout());
                this.socket.setReceiveBufferSize(this.bufferSize);
                this.socket.setSendBufferSize(this.bufferSize);
                this.logger.info((Object)("Connected to: " + uri.toString()));
                break;
            }
            catch (Exception e) {
                this.logger.debug((Object)("Failed to bind to uri: " + uri), (Throwable)e);
                if (i < count - 1) {
                    try {
                        Thread.sleep(freq);
                    }
                    catch (InterruptedException ignore) {}
                    continue;
                }
                throw new InitialisationException(new Message("udp", 1, (Object)uri), e, this);
            }
        }
    }

    protected DatagramSocket createSocket(URI uri, InetAddress inetAddress) throws IOException {
        return new DatagramSocket(uri.getPort(), inetAddress);
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    protected DatagramPacket createPacket() {
        DatagramPacket packet = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
        if (this.uri.getPort() > 0) {
            packet.setPort(this.uri.getPort());
        }
        packet.setAddress(this.inetAddress);
        return packet;
    }

    public void run() {
        while (!this.disposing.get()) {
            if (!this.connector.isStarted()) continue;
            try {
                DatagramPacket packet = this.createPacket();
                try {
                    this.socket.receive(packet);
                    this.logger.trace((Object)("Received packet on: " + this.inetAddress.toString()));
                    Work work = this.createWork(packet);
                    try {
                        this.getWorkManager().scheduleWork(work, Long.MAX_VALUE, null, null);
                    }
                    catch (WorkException e) {
                        this.logger.error((Object)("Udp receiver interrupted: " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
            }
            catch (Exception e) {
                if (this.connector.isDisposed() || this.disposing.get()) continue;
                this.logger.debug((Object)("Accept failed on socket: " + e), (Throwable)e);
                this.handleException(e);
            }
        }
    }

    public void release() {
        this.dispose();
    }

    public void doDispose() {
        this.socket.close();
        this.logger.info((Object)("Closed Udp connection: " + this.uri));
    }

    protected Work createWork(DatagramPacket packet) throws IOException {
        return new UdpWorker(new DatagramSocket(0), packet);
    }

    protected class UdpWorker
    implements Work,
    Disposable {
        private DatagramSocket socket = null;
        private DatagramPacket packet;

        public UdpWorker(DatagramSocket socket, DatagramPacket packet) {
            this.socket = socket;
            this.packet = packet;
        }

        public void release() {
            this.dispose();
        }

        public void dispose() {
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block9: {
                block8: {
                    UMOMessage returnMessage = null;
                    UMOMessageAdapter adapter = UdpMessageReceiver.this.connector.getMessageAdapter(this.packet);
                    returnMessage = UdpMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage(adapter), UdpMessageReceiver.this.endpoint.isSynchronous());
                    if (returnMessage == null) break block8;
                    byte[] data = returnMessage.getPayloadAsBytes();
                    DatagramPacket result = new DatagramPacket(data, data.length, this.packet.getAddress(), this.packet.getPort());
                    this.socket.send(result);
                }
                Object var6_6 = null;
                try {
                    this.socket.close();
                }
                catch (Exception e2) {
                    UdpMessageReceiver.this.logger.error((Object)("Socket close failed with: " + e2));
                }
                break block9;
                {
                    catch (Exception e) {
                        UdpMessageReceiver.this.handleException(e);
                        Object var6_7 = null;
                        try {
                            this.socket.close();
                        }
                        catch (Exception e2) {
                            UdpMessageReceiver.this.logger.error((Object)("Socket close failed with: " + e2));
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        this.socket.close();
                    }
                    catch (Exception e2) {
                        UdpMessageReceiver.this.logger.error((Object)("Socket close failed with: " + e2));
                    }
                    throw throwable;
                }
            }
        }
    }
}

