/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.vm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.vm.VMConnector;
import org.mule.providers.vm.VMMessageReceiver;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.NoReceiverForEndpointException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.queue.BoundedPersistentQueue;

public class VMMessageDispatcher
extends AbstractMessageDispatcher {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$vm$VMMessageDispatcher == null ? (class$org$mule$providers$vm$VMMessageDispatcher = VMMessageDispatcher.class$("org.mule.providers.vm.VMMessageDispatcher")) : class$org$mule$providers$vm$VMMessageDispatcher));
    private VMConnector connector;
    static /* synthetic */ Class class$org$mule$providers$vm$VMMessageDispatcher;

    public VMMessageDispatcher(VMConnector connector) {
        super(connector);
        this.connector = connector;
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        if (!this.connector.isQueueEvents()) {
            throw new UnsupportedOperationException("Receive only supported on the VM Queue Connector");
        }
        BoundedPersistentQueue queue = this.connector.getQueue(endpointUri.getAddress());
        if (queue == null) {
            return null;
        }
        UMOEvent event = null;
        try {
            event = (UMOEvent)queue.poll(timeout);
        }
        catch (InterruptedException e) {
            logger.error((Object)("failed to receive event from queue: " + endpointUri));
        }
        if (event != null) {
            return event.getMessage();
        }
        return null;
    }

    public void doDispatch(UMOEvent event) throws Exception {
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        if (endpointUri == null) {
            throw new DispatchException(new Message(45, "Endpoint"), event.getMessage(), event.getEndpoint());
        }
        if (this.connector.isQueueEvents()) {
            BoundedPersistentQueue queue = this.connector.getQueue(endpointUri.getAddress());
            if (queue == null) {
                logger.info((Object)("Creating vm Queue: " + endpointUri.getAddress()));
                queue = this.connector.createQueue(endpointUri.getAddress());
            }
            queue.put(event);
        } else {
            VMMessageReceiver receiver = this.connector.getReceiver(event.getEndpoint().getEndpointURI());
            if (receiver == null) {
                logger.warn((Object)("No receiver for endpointUri: " + event.getEndpoint().getEndpointURI()));
                return;
            }
            receiver.onEvent(event);
        }
        logger.debug((Object)("dispatched Event on endpointUri: " + endpointUri));
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        UMOMessage retMessage = null;
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        VMMessageReceiver receiver = this.connector.getReceiver(endpointUri);
        if (receiver == null) {
            if (this.connector.isQueueEvents()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Writing to queue as there is no receiver on connector: " + this.connector.getName() + ", for endpointUri: " + event.getEndpoint().getEndpointURI()));
                }
                this.doDispatch(event);
                return null;
            }
            throw new NoReceiverForEndpointException(new Message(118, this.connector.getName(), (Object)event.getEndpoint().getEndpointURI()));
        }
        retMessage = (UMOMessage)receiver.onCall(event);
        logger.debug((Object)("sent event on endpointUri: " + event.getEndpoint().getEndpointURI()));
        return retMessage;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public void doDispose() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

