/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import org.mule.impl.MuleMessage;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.routing.UMOOutboundMessageRouter;

public class ForwardingConsumer
extends SelectiveConsumer {
    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        if (super.process(event) != null) {
            UMOEndpoint endpoint = event.getComponent().getDescriptor().getOutboundEndpoint();
            UMOOutboundMessageRouter router = event.getComponent().getDescriptor().getOutboundRouter();
            if (endpoint == null && router == null) {
                this.logger.debug((Object)"Descriptor has no outbound endpoint configured to forward to, continuing with normal processing");
                return new UMOEvent[]{event};
            }
            try {
                if (router != null) {
                    router.route(event.getMessage(), event.getSession(), event.isSynchronous());
                    return null;
                }
                UMOEvent[] results = new UMOEvent[]{event.getSession().createOutboundEvent(new MuleMessage(event.getTransformedMessage(), event.getProperties()), endpoint, event)};
                this.logger.info((Object)("Forwarding event directly to: " + endpoint.getEndpointURI()));
                return results;
            }
            catch (UMOException e) {
                throw new RoutingException(event.getMessage(), endpoint, (Throwable)e);
            }
        }
        return null;
    }
}

