/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOEvent;
import org.mule.umo.routing.RoutingException;
import org.mule.util.Utility;

public class IdempotentReceiver
extends SelectiveConsumer {
    private static String DEFAULT_STORE_PATH = "./idempotent";
    private Set messageIds = new HashSet();
    private File idStore;
    private String componentName;
    private boolean disablePersistence = false;
    private String storePath;

    public IdempotentReceiver() {
        DEFAULT_STORE_PATH = MuleManager.getConfiguration().getWorkingDirectoy() + "/idempotent";
        this.setStorePath(DEFAULT_STORE_PATH);
    }

    public boolean isMatch(UMOEvent event) throws MessagingException {
        if (this.idStore == null) {
            this.load(event);
        }
        return !this.messageIds.contains(event.getMessage().getUniqueId());
    }

    public UMOEvent[] process(UMOEvent event) throws MessagingException {
        if (this.isMatch(event)) {
            try {
                this.checkComponentName(event.getComponent().getDescriptor().getName());
            }
            catch (IllegalArgumentException e) {
                throw new RoutingException(event.getMessage(), event.getEndpoint());
            }
            String id = event.getMessage().getUniqueId();
            try {
                this.storeId(id);
                return new UMOEvent[]{event};
            }
            catch (IOException e) {
                throw new RoutingException(new Message(94, id, (Object)this.idStore.getAbsolutePath()), event.getMessage(), event.getEndpoint(), e);
            }
        }
        return null;
    }

    private void checkComponentName(String name) throws IllegalArgumentException {
        if (!this.componentName.equals(name)) {
            throw new IllegalArgumentException("This receiver is assigned to component: " + this.componentName + " but has received an event for component: " + name + ". Please check your config to make sure each component" + "has its own instance of IdempotentReceiver");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void load(UMOEvent event) throws RoutingException {
        block9: {
            this.componentName = event.getComponent().getDescriptor().getName();
            this.idStore = new File(this.storePath + "/muleComponent_" + this.componentName + ".store");
            if (this.disablePersistence) {
                return;
            }
            try {
                if (this.idStore.exists()) {
                    BufferedReader reader = null;
                    try {
                        String id;
                        reader = new BufferedReader(new FileReader(this.idStore));
                        while ((id = reader.readLine()) != null) {
                            this.messageIds.add(id);
                        }
                        break block9;
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                this.idStore = Utility.createFile(this.idStore.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RoutingException(new Message(95, this.idStore.getAbsolutePath()), event.getMessage(), event.getEndpoint(), e);
            }
        }
    }

    protected synchronized void storeId(Object id) throws IOException {
        this.messageIds.add(id);
        if (this.disablePersistence) {
            return;
        }
        Utility.stringToFile(this.idStore.getAbsolutePath(), id.toString(), true, true);
    }

    public boolean isDisablePersistence() {
        return this.disablePersistence;
    }

    public void setDisablePersistence(boolean disablePersistence) {
        this.disablePersistence = disablePersistence;
    }

    public String getStorePath() {
        return this.storePath;
    }

    public void setStorePath(String storePath) {
        this.storePath = storePath == null ? DEFAULT_STORE_PATH : (storePath.endsWith("/") ? (storePath = storePath.substring(0, storePath.length() - 1)) : storePath);
    }
}

