/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.ArrayList;
import java.util.List;
import org.mule.MuleManager;
import org.mule.impl.MuleModel;
import org.mule.interceptors.LoggingInterceptor;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;

public abstract class AbstractUMOManagerTestCase
extends AbstractMuleTestCase {
    private static boolean initialised = false;

    protected void setUp() throws Exception {
        if (!initialised) {
            this.getUMOManager();
            initialised = true;
        }
    }

    public abstract UMOManager getUMOManager() throws Exception;

    public void testConnectorLookup() throws Exception {
        UMOConnector connector = MuleManager.getInstance().lookupConnector("testConnector");
        AbstractUMOManagerTestCase.assertNotNull((Object)connector);
        AbstractUMOManagerTestCase.assertEquals((int)1, (int)MuleManager.getInstance().getConnectors().size());
        TestConnector connector2 = AbstractUMOManagerTestCase.getTestConnector();
        MuleManager.getInstance().registerConnector(connector2);
        AbstractUMOManagerTestCase.assertEquals((int)2, (int)MuleManager.getInstance().getConnectors().size());
        AbstractUMOManagerTestCase.assertNull((Object)MuleManager.getInstance().lookupConnector("doesnotexist"));
    }

    public void testEndpointLookup() throws Exception {
        UMOEndpoint endpoint = MuleManager.getInstance().lookupEndpoint("testEndpoint");
        AbstractUMOManagerTestCase.assertNotNull((Object)endpoint);
        AbstractUMOManagerTestCase.assertEquals((int)1, (int)MuleManager.getInstance().getEndpoints().size());
        UMOEndpoint endpoint2 = AbstractUMOManagerTestCase.getTestEndpoint("testProvider2", "sender");
        MuleManager.getInstance().registerEndpoint(endpoint2);
        AbstractUMOManagerTestCase.assertEquals((int)2, (int)MuleManager.getInstance().getEndpoints().size());
        UMOEndpoint endpoint3 = MuleManager.getInstance().lookupEndpoint("doesnotexist");
        AbstractUMOManagerTestCase.assertNull((Object)endpoint3);
    }

    public void testTransformerLookup() throws Exception {
        UMOTransformer transformer = MuleManager.getInstance().lookupTransformer("testTransformer");
        AbstractUMOManagerTestCase.assertNotNull((Object)transformer);
        AbstractUMOManagerTestCase.assertEquals((int)1, (int)MuleManager.getInstance().getTransformers().size());
        UMOTransformer transformer2 = AbstractUMOManagerTestCase.getTestTransformer();
        MuleManager.getInstance().registerTransformer(transformer2);
        AbstractUMOManagerTestCase.assertEquals((int)2, (int)MuleManager.getInstance().getTransformers().size());
        UMOTransformer transformer3 = MuleManager.getInstance().lookupTransformer("doesnotexist");
        AbstractUMOManagerTestCase.assertNull((Object)transformer3);
    }

    public void testEndpointIdentifierLookup() throws Exception {
        String endpoint = MuleManager.getInstance().lookupEndpointIdentifier("testEndpointURI", null);
        AbstractUMOManagerTestCase.assertNotNull((Object)endpoint);
        AbstractUMOManagerTestCase.assertEquals((String)"test://endpoint.test", (String)endpoint);
        AbstractUMOManagerTestCase.assertEquals((int)1, (int)MuleManager.getInstance().getEndpointIdentifiers().size());
        MuleManager.getInstance().registerEndpointIdentifier("testEndpoint2", "endpointUri.test.2");
        AbstractUMOManagerTestCase.assertEquals((int)2, (int)MuleManager.getInstance().getEndpointIdentifiers().size());
        String endpoint2 = MuleManager.getInstance().lookupEndpointIdentifier("doesnotexist", null);
        AbstractUMOManagerTestCase.assertNull((Object)endpoint2);
    }

    public void testManagerProperties() {
        String value = (String)MuleManager.getInstance().getProperty("envProperty1");
        AbstractUMOManagerTestCase.assertEquals((String)"value1", (String)value);
        AbstractUMOManagerTestCase.assertEquals((int)1, (int)MuleManager.getInstance().getProperties().size());
    }

    public void testInterceptorStacks() {
        List interceptors = MuleManager.getInstance().lookupInterceptorStack("testInterceptorStack");
        AbstractUMOManagerTestCase.assertEquals((int)2, (int)interceptors.size());
        ArrayList<LoggingInterceptor> interceptors2 = new ArrayList<LoggingInterceptor>();
        interceptors2.add(new LoggingInterceptor());
        MuleManager.getInstance().registerInterceptorStack("testInterceptors2", interceptors2);
        AbstractUMOManagerTestCase.assertEquals((int)1, (int)MuleManager.getInstance().lookupInterceptorStack("testInterceptors2").size());
        List interceptors3 = MuleManager.getInstance().lookupInterceptorStack("doesnotexist");
        AbstractUMOManagerTestCase.assertNull((Object)interceptors3);
    }

    public void testTrasactionSetting() throws Exception {
        AbstractUMOManagerTestCase.assertNotNull((Object)MuleManager.getInstance().getTransactionManager());
        try {
            MuleManager.getInstance().setTransactionManager(null);
            AbstractUMOManagerTestCase.fail((String)"cannot set tx manager once it has been set");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testModelSetting() {
        AbstractUMOManagerTestCase.assertNotNull((Object)MuleManager.getInstance().getModel());
        MuleManager.getInstance().setModel(new MuleModel());
        AbstractUMOManagerTestCase.assertEquals((String)"mule", (String)MuleManager.getInstance().getModel().getName());
    }
}

