/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class PropertiesHelper {
    public static synchronized Properties loadProperties(String fileName) throws Exception {
        Properties p = null;
        FileInputStream is = new FileInputStream(fileName);
        p = new Properties();
        p.load(is);
        return p;
    }

    public static String removeXmlNamespacePrefix(String eleName) {
        int i = eleName.indexOf(":");
        return eleName.substring(i + 1, eleName.length());
    }

    public static String removeNamespacePrefix(String eleName) {
        int i = eleName.lastIndexOf(".");
        return eleName.substring(i + 1, eleName.length());
    }

    public static Map removeNamspaces(Map properties) {
        HashMap props = new HashMap(properties.size());
        Iterator iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            props.put(PropertiesHelper.removeNamespacePrefix((String)entry.getKey()), entry.getValue());
        }
        return props;
    }

    public static Object getProperty(Map props, Object key, Object defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        Object temp = props.get(key);
        if (temp == null) {
            temp = defaultValue;
        }
        return temp;
    }

    public static String getStringProperty(Map props, Object key, String defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        Object temp = props.get(key);
        if (temp == null) {
            temp = defaultValue;
        }
        return temp == null ? null : temp.toString();
    }

    public static int getIntProperty(Map props, Object key, int defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        int ret = defaultValue;
        Object temp = props.get(key);
        if (temp != null) {
            try {
                ret = Integer.parseInt(temp.toString());
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static long getLongProperty(Map props, Object key, long defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        long ret = defaultValue;
        Object temp = props.get(key);
        if (temp != null) {
            try {
                ret = Long.parseLong(temp.toString());
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static double getDoubleProperty(Map props, Object key, double defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        double ret = defaultValue;
        Object temp = props.get(key);
        if (temp != null) {
            try {
                ret = Double.parseDouble(temp.toString());
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static boolean getBooleanProperty(Map props, Object key, boolean defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        boolean ret = defaultValue;
        Object temp = props.get(key);
        if (temp != null) {
            try {
                ret = Boolean.valueOf(temp.toString());
            }
            catch (NumberFormatException e) {
                ret = defaultValue;
            }
        }
        return ret;
    }

    public static Map reverseProperties(Map props) {
        HashMap newProps = new HashMap();
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            newProps.put(entry.getValue(), entry.getKey());
        }
        return newProps;
    }

    public static int getIntValue(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.parseInt(value.toString());
    }

    public static long getLongValue(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.parseLong(value.toString());
    }

    public static boolean getBooleanValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    public static Map getPropertiesWithPrefix(Map props, String prefix) {
        HashMap newProps = new HashMap();
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getKey().toString().startsWith(prefix)) continue;
            newProps.put(entry.getKey(), entry.getValue());
        }
        return newProps;
    }

    public static Map getPropertiesWithoutPrefix(Map props, String prefix) {
        HashMap newProps = new HashMap();
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getKey().toString().startsWith(prefix)) continue;
            newProps.put(entry.getKey(), entry.getValue());
        }
        return newProps;
    }

    public static Properties getPropertiesFromQueryString(String query) {
        Properties props = new Properties();
        if (query == null) {
            return props;
        }
        query = "&" + query;
        int x = 0;
        while ((x = PropertiesHelper.addProperty(query, x, props)) != -1) {
        }
        return props;
    }

    /*
     * WARNING - void declaration
     */
    private static int addProperty(String query, int start, Properties properties) {
        void var5_5;
        String pair;
        int i = query.indexOf("&", start);
        int i2 = query.indexOf("&", i + 1);
        if (i > -1 && i2 > -1) {
            pair = query.substring(i + 1, i2);
        } else if (i > -1) {
            pair = query.substring(i + 1);
        } else {
            return -1;
        }
        int eq = var5_5.indexOf("=");
        if (eq <= 0) {
            void key = var5_5;
            String value = "";
            properties.setProperty((String)key, value);
        } else {
            String key = var5_5.substring(0, eq);
            String value = eq == var5_5.length() ? "" : var5_5.substring(eq + 1);
            properties.setProperty(key, value);
        }
        return i2;
    }

    public static String propertiesToString(Map props, boolean newline) {
        StringBuffer buf = new StringBuffer();
        buf.append("Properties{");
        if (newline) {
            buf.append("\n");
        }
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!newline) {
                buf.append(", ");
            }
            buf.append(entry.getKey()).append("=").append(entry.getValue());
            if (!newline) continue;
            buf.append("\n");
        }
        buf.append("}");
        return buf.toString();
    }
}

