/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.compression;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.ClassHelper;
import org.mule.util.compression.CompressionException;
import org.mule.util.compression.CompressionStrategy;

public class CompressionHelper {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$util$compression$CompressionHelper == null ? (class$org$mule$util$compression$CompressionHelper = CompressionHelper.class$("org.mule.util.compression.CompressionHelper")) : class$org$mule$util$compression$CompressionHelper));
    private static CompressionStrategy strategy = CompressionHelper.getCompressionStrategy();
    static /* synthetic */ Class class$org$mule$util$compression$CompressionHelper;

    public static final CompressionStrategy getCompressionStrategy() {
        return (CompressionStrategy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Object o = ClassHelper.loadClass("org.mule.util.compression.GZipCompression", class$org$mule$util$compression$CompressionHelper == null ? (class$org$mule$util$compression$CompressionHelper = CompressionHelper.class$("org.mule.util.compression.CompressionHelper")) : class$org$mule$util$compression$CompressionHelper).newInstance();
                    logger.debug((Object)("Found CompressionStrategy: " + o.getClass().getName()));
                    return o;
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to build compression strategy: " + e.getMessage()));
                    return null;
                }
            }
        });
    }

    public static byte[] compressByteArray(byte[] bytes) throws IOException {
        logger.debug((Object)("Compressing message of size: " + bytes.length));
        byte[] compressedByteArray = strategy.compressByteArray(bytes);
        logger.debug((Object)("Compressed message to size: " + compressedByteArray.length));
        return compressedByteArray;
    }

    public static byte[] uncompressByteArray(byte[] bytes) throws IOException {
        logger.debug((Object)("Uncompressing message of size: " + bytes.length));
        if (!strategy.isCompressed(bytes)) {
            logger.warn((Object)"data is not of type GZIP compressed. The data may not have been compressed in the first place");
            throw new CompressionException("Not in GZIP format");
        }
        byte[] uncompressedByteArray = strategy.uncompressByteArray(bytes);
        logger.debug((Object)("Uncompressing message to size: " + uncompressedByteArray.length));
        return uncompressedByteArray;
    }

    public static boolean isCompressed(byte[] bytes) throws IOException {
        return strategy.isCompressed(bytes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

