/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import org.mule.umo.UMOEvent;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.queue.PersistenceStrategy;
import org.mule.util.queue.PersistentQueueException;

public class BoundedPersistentQueue
extends BoundedBuffer
implements Disposable {
    private PersistenceStrategy ps;
    private boolean deleteOnTake = true;

    public BoundedPersistentQueue(int i) throws IllegalArgumentException {
        super(i);
    }

    public BoundedPersistentQueue(int i, PersistenceStrategy ps, String name, boolean deleteOnTake) throws IllegalArgumentException, InitialisationException {
        super(i);
        this.ps = ps;
        this.deleteOnTake = deleteOnTake;
        if (ps != null) {
            ps.initialise((BoundedChannel)this, name);
        }
    }

    public void put(Object o) throws InterruptedException {
        if (this.ps != null) {
            this.ps.store((UMOEvent)o);
        }
        super.put(o);
    }

    public Object take() throws InterruptedException {
        Object o = super.take();
        if (this.deleteOnTake) {
            this.remove((UMOEvent)o);
        }
        return o;
    }

    public boolean remove(Object o) throws PersistentQueueException {
        if (this.ps != null) {
            return this.ps.remove((UMOEvent)o);
        }
        return false;
    }

    public boolean isDeleteOnTake() {
        return this.deleteOnTake;
    }

    public void setDeleteOnTake(boolean deleteOnTake) {
        this.deleteOnTake = deleteOnTake;
    }

    public PersistenceStrategy getPersistenceStrategy() {
        return this.ps;
    }

    public void dispose() {
        if (this.ps != null) {
            this.ps.dispose();
        }
    }
}

