/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.Serializable;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleEvent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;

public class EventHolder
implements Serializable {
    private String eventId;
    private UMOMessage message;
    private String componentName;
    private String endpointName;
    private boolean synchronous;
    private boolean stopFurtherProcessing;
    private int timeout;

    public EventHolder(UMOEvent event) {
        this.eventId = event.getId();
        this.synchronous = event.isSynchronous();
        this.stopFurtherProcessing = event.isStopFurtherProcessing();
        this.message = event.getMessage();
        this.componentName = event.getComponent().getDescriptor().getName();
        this.endpointName = event.getEndpoint().getName();
        this.timeout = event.getTimeout();
    }

    public UMOEvent getEvent() throws InitialisationException {
        UMOSession session = MuleManager.getInstance().getModel().getComponentSession(this.componentName);
        if (session == null) {
            throw new InitialisationException(new Message(62, this.componentName), (Object)this);
        }
        UMOEndpoint endpoint = session.getComponent().getDescriptor().getInboundRouter().getEndpoint(this.endpointName);
        if (endpoint == null && (endpoint = MuleManager.getInstance().lookupEndpoint(this.endpointName)) == null) {
            throw new InitialisationException(new Message(63, this.componentName), (Object)this);
        }
        MuleEvent event = new MuleEvent(this.message, endpoint, session, this.eventId, this.synchronous);
        event.setStopFurtherProcessing(this.stopFurtherProcessing);
        event.setTimeout(this.timeout);
        return event;
    }
}

