/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.umo.UMOEvent;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.queue.EventHolder;
import org.mule.util.queue.PersistenceStrategy;
import org.mule.util.queue.PersistentQueueException;

public class SerialisationPersistence
implements PersistenceStrategy {
    public static final String DEFAULT_QUEUE_STORE = MuleManager.getConfiguration().getWorkingDirectoy() + "/queuestore";
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$util$queue$SerialisationPersistence == null ? (class$org$mule$util$queue$SerialisationPersistence = SerialisationPersistence.class$("org.mule.util.queue.SerialisationPersistence")) : class$org$mule$util$queue$SerialisationPersistence));
    private File store;
    private Object lock = new Object();
    private String queueStore = DEFAULT_QUEUE_STORE;
    static /* synthetic */ Class class$org$mule$util$queue$SerialisationPersistence;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(UMOEvent event) throws PersistentQueueException {
        Object object = this.lock;
        synchronized (object) {
            File item = new File(this.store, event.getEndpoint().getEndpointURI().getAddress() + "/" + event.getId() + ".e");
            try {
                EventHolder eventHolder = new EventHolder(event);
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(item));
                oos.writeObject(eventHolder);
                oos.close();
            }
            catch (IOException e) {
                throw new PersistentQueueException(new Message(148, event.getId()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(UMOEvent event) throws PersistentQueueException {
        File item = new File(this.store, event.getComponent().getDescriptor().getName() + "/" + event.getId() + ".e");
        if (item.exists()) {
            Object object = this.lock;
            synchronized (object) {
                return item.delete();
            }
        }
        return false;
    }

    public synchronized void initialise(BoundedChannel queue, String componentName) throws InitialisationException {
        if (queue == null) {
            throw new InitialisationException(new Message(45, "Queue"), (Object)this);
        }
        if (this.store == null) {
            this.store = new File(this.getQueueStore());
        }
        File componentStore = new File(this.store, componentName);
        try {
            if (componentStore.exists()) {
                String[] events = componentStore.list(new EventFilenameFilter());
                for (int i = 0; i < events.length; ++i) {
                    String event = events[i];
                    File eventFile = new File(componentStore, event);
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(eventFile));
                    EventHolder eventHolder = (EventHolder)ois.readObject();
                    UMOEvent umoEvent = eventHolder.getEvent();
                    queue.put((Object)umoEvent);
                    ois.close();
                }
            } else if (!componentStore.mkdirs()) {
                throw new InitialisationException(new Message(65, "Queue Store: " + this.store.getAbsolutePath()), (Object)this);
            }
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(65, "Queue Persistent Store"), e, this);
        }
    }

    public String getQueueStore() {
        return this.queueStore;
    }

    public void setQueueStore(String queueStore) {
        this.queueStore = queueStore;
    }

    public void dispose() throws PersistentQueueException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class EventFilenameFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(".e");
        }
    }
}

