/*
 * $Header: /home/projects/mule/scm/mule/samples/loanbroker/src/java/org/mule/samples/loanbroker/LoanQuote.java,v 1.2 2005/04/14 06:08:15 rossmason Exp $
 * $Revision: 1.2 $
 * $Date: 2005/04/14 06:08:15 $
 * ------------------------------------------------------------------------------------------------------
 *
 * Copyright (c) SymphonySoft Limited. All rights reserved.
 * http://www.symphonysoft.com
 *
 * The software in this package is published under the terms of the BSD
 * style license a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.mule.samples.loanbroker;

import java.io.Serializable;

/**
 * <code>LoanQuote</code> is a loan quote from a bank
 *
 * @author <a href="mailto:ross.mason@symphonysoft.com">Ross Mason</a>
 * @version $Revision: 1.2 $
 */

public class LoanQuote implements Serializable
{
    private String bankName;
    private double interestRate = 0;

    public String getBankName()
    {
        return bankName;
    }

    public void setBankName(String bankName)
    {
        this.bankName = bankName;
    }

    public double getInterestRate()
    {
        return interestRate;
    }

    public void setInterestRate(double interestRate)
    {
        this.interestRate = interestRate;
    }

    public String toString()
    {
        return bankName + ", rate: " + interestRate;
    }
}
