/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.transaction.TransactionManager;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.InitialisationException;
import org.mule.MuleRuntimeException;
import org.mule.MuleServer;
import org.mule.config.ConfigurationException;
import org.mule.config.MuleConfiguration;
import org.mule.impl.AlreadyInitialisedException;
import org.mule.impl.MuleModel;
import org.mule.impl.internal.admin.MuleAdminAgent;
import org.mule.impl.internal.events.CustomEvent;
import org.mule.impl.internal.events.ManagerEvent;
import org.mule.impl.internal.events.ServerEventManager;
import org.mule.management.stats.AllStatistics;
import org.mule.model.MuleContainerContext;
import org.mule.umo.UMOAgent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManager;
import org.mule.umo.UMOServerEvent;
import org.mule.umo.UMOServerEventListener;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.model.ComponentResolverException;
import org.mule.umo.model.UMOContainerContext;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.PropertiesHelper;
import org.mule.util.SpiHelper;
import org.mule.util.StringMessageHelper;
import org.mule.util.Utility;
import org.w3c.dom.DocumentFragment;

public class MuleManager
implements UMOManager {
    private static UMOManager instance = null;
    private static MuleConfiguration config = new MuleConfiguration();
    private Map connectors = new HashMap();
    private Map endpointIdentifiers = new HashMap();
    private Map applicationProps = new HashMap();
    private Map agents = new HashMap();
    private Map endpoints = new HashMap();
    private UMOModel model;
    private String id = null;
    private TransactionManager transactionManager = null;
    private HashMap transformers = new HashMap();
    private SynchronizedBoolean initialised = new SynchronizedBoolean(false);
    private SynchronizedBoolean initialising = new SynchronizedBoolean(false);
    private SynchronizedBoolean started = new SynchronizedBoolean(false);
    private SynchronizedBoolean starting = new SynchronizedBoolean(false);
    private SynchronizedBoolean disposed = new SynchronizedBoolean(false);
    private static MuleServer server = null;
    private HashMap interceptorsMap = new HashMap();
    private long startDate = 0L;
    private AllStatistics stats = new AllStatistics();
    private ServerEventManager listeners = new ServerEventManager();
    private UMOContainerContext containerContext = null;
    private DocumentFragment containerContextConfiguration = null;
    private UMOSecurityManager securityManager;
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$MuleManager == null ? (class$org$mule$MuleManager = MuleManager.class$("org.mule.MuleManager")) : class$org$mule$MuleManager));
    private boolean containerConfigured = false;
    static /* synthetic */ Class class$org$mule$MuleManager;
    static /* synthetic */ Class class$org$mule$umo$UMOManager;

    private MuleManager() {
        if (config == null) {
            config = new MuleConfiguration();
        }
        this.setModel(new MuleModel());
        this.setContainerContext(new MuleContainerContext());
    }

    protected static UMOManager createInstance() throws MuleRuntimeException {
        Class clazz = SpiHelper.findService(class$org$mule$umo$UMOManager == null ? (class$org$mule$umo$UMOManager = MuleManager.class$("org.mule.umo.UMOManager")) : class$org$mule$umo$UMOManager, (class$org$mule$MuleManager == null ? (class$org$mule$MuleManager = MuleManager.class$("org.mule.MuleManager")) : class$org$mule$MuleManager).getName(), class$org$mule$MuleManager == null ? (class$org$mule$MuleManager = MuleManager.class$("org.mule.MuleManager")) : class$org$mule$MuleManager);
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            throw new MuleRuntimeException("Failed to create UMOManager instance: " + clazz.getName(), e);
        }
        MuleManager.setInstance(obj);
        return MuleManager.getInstance();
    }

    public static synchronized UMOManager getInstance() {
        if (instance == null) {
            instance = MuleManager.createInstance();
        }
        return instance;
    }

    public static boolean isInstanciated() {
        return instance != null;
    }

    public static synchronized void setInstance(UMOManager manager) {
        instance = manager;
        if (instance == null) {
            config = new MuleConfiguration();
        }
    }

    public AllStatistics getStatistics() {
        return this.stats;
    }

    public void setStatistics(AllStatistics stat) {
        this.stats = stat;
    }

    public static MuleConfiguration getConfiguration() {
        return config;
    }

    public static void setConfiguration(MuleConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration cannot be null");
        }
        MuleManager.config = config;
    }

    public synchronized void dispose() throws UMOException {
        if (this.disposed.get()) {
            return;
        }
        if (this.started.get()) {
            this.stop();
        }
        this.disposed.set(true);
        this.disposeConnectors();
        this.model.dispose();
        this.listeners.dispose();
        this.disposeAgents();
        this.transformers.clear();
        this.endpoints.clear();
        this.endpointIdentifiers.clear();
        this.fireSystemEvent(new ManagerEvent(this, 108));
        this.transformers = null;
        this.endpoints = null;
        this.endpointIdentifiers = null;
        this.initialised.set(false);
        this.listeners.clear();
        instance = null;
        System.out.println(this.getEndSplash());
    }

    private void disposeConnectors() {
        this.fireSystemEvent(new ManagerEvent(this, 109));
        Iterator iterator = this.connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector c = (UMOConnector)iterator.next();
            try {
                c.dispose();
            }
            catch (UMOException e) {
                logger.error((Object)("Connector " + c.getName() + " failed to dispose: " + e.getMessage()), (Throwable)e);
            }
        }
        this.fireSystemEvent(new ManagerEvent(this, 110));
    }

    public Object getProperty(Object key) {
        return this.applicationProps.get(key);
    }

    public Map getProperties() {
        return this.applicationProps;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public UMOConnector lookupConnector(String name) {
        return (UMOConnector)this.connectors.get(name);
    }

    public String lookupEndpointIdentifier(String logicalName, String defaultName) {
        String name = (String)this.endpointIdentifiers.get(logicalName);
        if (name == null) {
            return defaultName;
        }
        return name;
    }

    public UMOEndpoint lookupEndpoint(String logicalName) {
        UMOEndpoint endpoint = (UMOEndpoint)this.endpoints.get(logicalName);
        if (endpoint != null) {
            return (UMOEndpoint)endpoint.clone();
        }
        return null;
    }

    public UMOTransformer lookupTransformer(String name) {
        UMOTransformer trans = (UMOTransformer)this.transformers.get(name);
        if (trans != null) {
            try {
                return (UMOTransformer)trans.clone();
            }
            catch (Exception e) {
                throw new NoSuchElementException("Failed to clone global transformer + " + trans.getName() + ": " + e.getMessage());
            }
        }
        return null;
    }

    public void registerConnector(UMOConnector connector) throws UMOException {
        this.connectors.put(connector.getName(), connector);
        if (this.initialised.get() || this.initialising.get()) {
            try {
                connector.initialise();
            }
            catch (AlreadyInitialisedException e) {
            }
            catch (Exception e) {
                throw new InitialisationException("Failed to initilaise Connector: " + e.getMessage(), e);
            }
        }
        if ((this.started.get() || this.starting.get()) && !connector.isStarted()) {
            connector.start();
        }
    }

    public void unregisterConnector(String connectorName) throws UMOException {
        UMOConnector c = (UMOConnector)this.connectors.remove(connectorName);
        if (c != null) {
            c.dispose();
        }
    }

    public void registerEndpointIdentifier(String logicalName, String endpoint) {
        this.endpointIdentifiers.put(logicalName, endpoint);
    }

    public void unregisterEndpointIdentifier(String logicalName) {
        this.endpointIdentifiers.remove(logicalName);
    }

    public void registerEndpoint(UMOEndpoint endpoint) {
        this.endpoints.put(endpoint.getName(), endpoint);
    }

    public void unregisterEndpoint(String endpointName) {
        UMOEndpoint p = (UMOEndpoint)this.endpoints.get(endpointName);
        if (p != null) {
            this.endpoints.remove(p);
        }
    }

    public void registerTransformer(UMOTransformer transformer) throws InitialisationException {
        try {
            transformer.initialise();
        }
        catch (Exception e) {
            throw new InitialisationException("Failed to initialise transformer: " + transformer.getName() + ", " + e.getMessage(), e);
        }
        this.transformers.put(transformer.getName(), transformer);
        logger.info((Object)("Transformer" + transformer.getName() + " has been initialised successfully"));
    }

    public void unregisterTransformer(String transformerName) {
        this.transformers.remove(transformerName);
    }

    public void setProperty(Object key, Object value) {
        this.applicationProps.put(key, value);
    }

    public void setTransactionManager(TransactionManager newManager) throws UMOException {
        if (this.transactionManager != null) {
            throw new ConfigurationException("The transaction manager on the MuleManager cannot be set one one has already been set");
        }
        this.transactionManager = newManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initialise() throws UMOException {
        if (!this.initialised.get()) {
            this.initialising.set(true);
            this.fireSystemEvent(new ManagerEvent(this, 101));
            if (this.id == null) {
                logger.warn((Object)"No unique id has be set on this manager");
            }
            try {
                if (this.securityManager != null) {
                    this.securityManager.initialise();
                }
                boolean disable = PropertiesHelper.getBooleanProperty(System.getProperties(), "org.mule.disable.server.connections", false);
                if (config.getServerUrl() == null || "".equals(config.getServerUrl().trim())) {
                    logger.info((Object)"Server endpointUri is null, not registering Mule Admin agent");
                    disable = true;
                }
                if (!disable) {
                    this.registerAgent(new MuleAdminAgent());
                }
                this.initialiseConnectors();
                this.initialiseEndpoints();
                this.initialiseAgents();
                try {
                    this.model.initialise();
                }
                catch (Exception e) {
                    throw new InitialisationException("Failed to initialise the model: " + e.getMessage(), e);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.initialised.set(true);
                this.initialising.set(false);
                this.fireSystemEvent(new ManagerEvent(this, 102));
                throw throwable;
            }
            this.initialised.set(true);
            this.initialising.set(false);
            this.fireSystemEvent(new ManagerEvent(this, 102));
            {
            }
        }
    }

    protected void initialiseEndpoints() throws InitialisationException {
        Iterator iterator = this.endpoints.values().iterator();
        while (iterator.hasNext()) {
            ((UMOImmutableEndpoint)iterator.next()).initialise();
        }
    }

    public synchronized void start() throws UMOException {
        this.initialise();
        if (!this.started.get()) {
            this.startDate = System.currentTimeMillis();
            this.starting.set(true);
            this.fireSystemEvent(new ManagerEvent(this, 103));
            this.startConnectors();
            this.startAgents();
            this.model.start();
            this.started.set(true);
            this.starting.set(false);
            System.out.println(this.getStartSplash());
            this.fireSystemEvent(new ManagerEvent(this, 104));
        }
    }

    public void start(String serverUrl) throws UMOException {
        config.setServerUrl(serverUrl);
        this.start();
    }

    private void startConnectors() throws UMOException {
        Iterator iterator = this.connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector c = (UMOConnector)iterator.next();
            c.start();
        }
        logger.info((Object)"Connectors have been started successfully");
    }

    private void initialiseConnectors() throws InitialisationException {
        Iterator iterator = this.connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector c = (UMOConnector)iterator.next();
            c.initialise();
        }
        logger.info((Object)"Connectors have been initialised successfully");
    }

    public synchronized void stop() throws UMOException {
        this.fireSystemEvent(new ManagerEvent(this, 105));
        logger.debug((Object)"Stopping connectors...");
        this.stopConnectors();
        this.stopAgents();
        logger.debug((Object)"Stopping model...");
        this.model.stop();
        this.fireSystemEvent(new ManagerEvent(this, 106));
    }

    private void stopConnectors() throws UMOException {
        Iterator iterator = this.connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector c = (UMOConnector)iterator.next();
            c.stop();
        }
        logger.info((Object)"Connectors have been stopped successfully");
    }

    void setServer(MuleServer server) {
        MuleManager.server = server;
    }

    public void shutdown(Throwable e, boolean aggressive) {
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(e, aggressive));
        System.exit(0);
    }

    public UMOModel getModel() {
        return this.model;
    }

    public void setModel(UMOModel model) {
        this.model = model;
        if (model instanceof MuleModel) {
            ((MuleModel)model).setListeners(this.listeners);
        }
    }

    public void registerInterceptorStack(String name, List stack) {
        this.interceptorsMap.put(name, stack);
    }

    public List lookupInterceptorStack(String name) {
        return (List)this.interceptorsMap.get(name);
    }

    public Map getConnectors() {
        return Collections.unmodifiableMap(this.connectors);
    }

    public Map getEndpointIdentifiers() {
        return Collections.unmodifiableMap(this.endpointIdentifiers);
    }

    public Map getEndpoints() {
        return Collections.unmodifiableMap(this.endpoints);
    }

    public Map getTransformers() {
        return Collections.unmodifiableMap(this.transformers);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    public boolean isInitialising() {
        return this.initialising.get();
    }

    public long getStartDate() {
        return this.startDate;
    }

    protected String getStartSplash() {
        ArrayList<String> message = new ArrayList<String>();
        Manifest mf = config.getManifest();
        Attributes att = mf.getMainAttributes();
        if (att.values().size() > 0) {
            message.add(PropertiesHelper.getStringProperty(att, new Attributes.Name("Specification-Title"), "Not Set") + " version " + PropertiesHelper.getStringProperty(att, new Attributes.Name("Implementation-Version"), "Not Set"));
            message.add(PropertiesHelper.getStringProperty(att, new Attributes.Name("Specification-Vendor"), "Not Set"));
            message.add(PropertiesHelper.getStringProperty(att, new Attributes.Name("Implementation-Vendor"), "Not Set"));
        } else {
            message.add("Mule Version Info not set");
        }
        message.add(" ");
        message.add("Server started: " + new Date(this.getStartDate()).toString());
        message.add("JDK: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.info") + ")");
        message.add(" ");
        if (this.agents.size() == 0) {
            message.add("Agents Running: None");
        } else {
            message.add("Agents Running:");
            Iterator iterator = this.agents.values().iterator();
            while (iterator.hasNext()) {
                UMOAgent umoAgent = (UMOAgent)iterator.next();
                message.add("  " + umoAgent.getDescription());
            }
        }
        return StringMessageHelper.getBoilerPlate(message, '*', 70);
    }

    private String getEndSplash() {
        ArrayList<String> message = new ArrayList<String>(2);
        long currentTime = System.currentTimeMillis();
        message.add("Mule shut down normally on: " + new Date());
        long duration = currentTime;
        if (this.startDate > 0L) {
            duration = currentTime - this.startDate;
        }
        message.add("Server was up for: " + Utility.getFormattedDuration(duration));
        return StringMessageHelper.getBoilerPlate(message, '*', 70);
    }

    public void registerAgent(UMOAgent agent) throws UMOException {
        this.agents.put(agent.getName(), agent);
        agent.registered();
    }

    public UMOAgent removeAgent(String name) throws UMOException {
        UMOAgent agent = (UMOAgent)this.agents.remove(name);
        if (agent != null) {
            agent.dispose();
        }
        agent.unregistered();
        return agent;
    }

    protected void initialiseAgents() throws InitialisationException {
        logger.info((Object)"Initialising agents...");
        Iterator iterator = this.agents.values().iterator();
        while (iterator.hasNext()) {
            UMOAgent umoAgent = (UMOAgent)iterator.next();
            logger.debug((Object)("Initialising agent: " + umoAgent.getName()));
            umoAgent.initialise();
        }
        logger.info((Object)"Agents Successfully Initialised");
    }

    protected void startAgents() throws UMOException {
        logger.info((Object)"Starting agents...");
        Iterator iterator = this.agents.values().iterator();
        while (iterator.hasNext()) {
            UMOAgent umoAgent = (UMOAgent)iterator.next();
            logger.debug((Object)("Starting agent: " + umoAgent.getName()));
            umoAgent.start();
        }
        logger.info((Object)"Agents Successfully Started");
    }

    protected void stopAgents() throws UMOException {
        logger.info((Object)"Stopping agents...");
        Iterator iterator = this.agents.values().iterator();
        while (iterator.hasNext()) {
            UMOAgent umoAgent = (UMOAgent)iterator.next();
            logger.debug((Object)("Stopping agent: " + umoAgent.getName()));
            umoAgent.stop();
        }
        logger.info((Object)"Agents Successfully Stopped");
    }

    protected void disposeAgents() throws UMOException {
        logger.info((Object)"disposing agents...");
        Iterator iterator = this.agents.values().iterator();
        while (iterator.hasNext()) {
            UMOAgent umoAgent = (UMOAgent)iterator.next();
            logger.debug((Object)("Disposing agent: " + umoAgent.getName()));
            umoAgent.dispose();
        }
        logger.info((Object)"Agents Successfully Disposed");
    }

    public void setContainerContext(UMOContainerContext context) {
        this.containerContext = context;
    }

    public UMOContainerContext getContainerContext() throws ComponentResolverException {
        if (!this.containerConfigured) {
            Reader config = this.getContainerContextConfiguration();
            if (config != null) {
                this.containerContext.configure(config, Collections.EMPTY_MAP);
            }
            this.containerConfigured = true;
        }
        return this.containerContext;
    }

    public void setContainerContextConfiguration(DocumentFragment containerContextConfiguration) {
        this.containerContextConfiguration = containerContextConfiguration;
    }

    public void registerListener(UMOServerEventListener l) {
        this.listeners.registerListener(l);
    }

    public void unregisterListener(UMOServerEventListener l) {
        this.listeners.unregisterListener(l);
    }

    protected void fireSystemEvent(UMOServerEvent e) {
        this.listeners.fireEvent(e);
    }

    public void fireEvent(UMOServerEvent event) {
        if (!(event instanceof CustomEvent)) {
            throw new UnsupportedOperationException("Only CustomEvent events can be fired through the MuleManager");
        }
        this.listeners.fireEvent(event);
    }

    protected Reader getContainerContextConfiguration() throws ConfigurationException {
        StringReader result = null;
        if (this.containerContextConfiguration != null) {
            StringWriter s = new StringWriter();
            StreamResult streamResult = new StreamResult(s);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            try {
                Transformer transformer = tFactory.newTransformer();
                transformer.transform(new DOMSource(this.containerContextConfiguration), streamResult);
            }
            catch (TransformerException e) {
                throw new ConfigurationException("could not recover container configuration from fragment", e);
            }
            result = new StringReader(s.toString());
        }
        return result;
    }

    public void setId(String id) {
        if (this.id == null) {
            this.id = id;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setSecurityManager(UMOSecurityManager securityManager) throws InitialisationException {
        this.securityManager = securityManager;
        if (securityManager != null && this.isInitialised()) {
            this.securityManager.initialise();
        }
    }

    public UMOSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ShutdownThread
    extends Thread {
        Throwable t;
        boolean aggressive = true;

        public ShutdownThread(Throwable t, boolean aggressive) {
            this.t = t;
            this.aggressive = aggressive;
        }

        public void run() {
            try {
                MuleManager.this.dispose();
            }
            catch (UMOException e) {
                logger.fatal((Object)("Exception caught while destroying the Server: " + e));
            }
            if (!this.aggressive) {
                // empty if block
            }
            if (server != null) {
                if (this.t != null) {
                    server.shutdown(this.t);
                } else {
                    server.shutdown();
                }
            } else {
                ArrayList<String> msgs = new ArrayList<String>();
                if (this.t != null) {
                    msgs.add("Mule is shutting down due to exception: " + this.t.getMessage());
                } else {
                    msgs.add("Mule is shutting down due to normal shutdown request.");
                }
                msgs.add("Shutdown time is: " + new Date().toString());
                StringMessageHelper.getBoilerPlate(msgs, '*', 76);
            }
        }
    }
}

