/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.util.ClassHelper;
import org.mule.util.StringMessageHelper;

public class MuleServer
implements Runnable {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$MuleServer == null ? (class$org$mule$MuleServer = MuleServer.class$("org.mule.MuleServer")) : class$org$mule$MuleServer));
    public static final String DEFAULT_CONFIGURATION = "mule-config.xml";
    private static String shutdownMessage = null;
    private String configurationResources;
    private static ConfigurationBuilder configBuilder = null;
    static /* synthetic */ Class class$org$mule$MuleServer;

    public MuleServer() {
    }

    public MuleServer(String configResources) {
        this.setConfigurationResources(configResources);
    }

    public static void main(String[] args) {
        String builder;
        MuleServer server = new MuleServer();
        List<String> opts = Arrays.asList(args);
        String config = null;
        if (opts.size() > 0) {
            config = MuleServer.getOption("-config", opts);
            if (config != null) {
                server.setConfigurationResources(config);
            }
        } else {
            URL configUrl = ClassHelper.getResource(DEFAULT_CONFIGURATION, class$org$mule$MuleServer == null ? (class$org$mule$MuleServer = MuleServer.class$("org.mule.MuleServer")) : class$org$mule$MuleServer);
            if (configUrl != null) {
                config = configUrl.toExternalForm();
                server.setConfigurationResources(config);
            }
        }
        if (config == null) {
            System.out.println("No config file was specified and no config by the name of mule-config.xml was found on the classpath");
            System.out.println("Usage: MuleServer -config <mule-configuration> [-builder <config-builder>]");
            System.out.println("   mule-configuration = a URL for the Mule Config XML to use, if not specified the config will be loaded from the class path");
            System.out.println("   config-builder = a fully qualified class name of the builder to use to configure Mule");
            System.exit(0);
        }
        if ((builder = MuleServer.getOption("-builder", opts)) != null) {
            try {
                configBuilder = (ConfigurationBuilder)ClassHelper.loadClass(builder, class$org$mule$MuleServer == null ? (class$org$mule$MuleServer = MuleServer.class$("org.mule.MuleServer")) : class$org$mule$MuleServer).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Failed to load builder: " + builder);
            }
        } else {
            configBuilder = new MuleXmlConfigurationBuilder();
        }
        server.start(false);
    }

    private static String getOption(String option, List options) {
        int i;
        if (options.contains(option) && (i = options.indexOf(option)) < options.size() - 1) {
            return options.get(i + 1).toString();
        }
        return null;
    }

    public void start(boolean ownThread) {
        if (ownThread) {
            Thread serverThread = new Thread((Runnable)this, "MuleServer");
            serverThread.setDaemon(true);
            serverThread.start();
        } else {
            this.run();
        }
    }

    public void run() {
        try {
            this.initialize();
        }
        catch (Throwable e) {
            this.shutdown(e);
        }
    }

    public String getConfigurationResources() {
        return this.configurationResources;
    }

    public void setConfigurationResources(String configurationResources) {
        this.configurationResources = configurationResources;
    }

    public static ConfigurationBuilder getConfigBuilder() {
        return configBuilder;
    }

    public static void setConfigBuilder(ConfigurationBuilder configBuilder) {
        MuleServer.configBuilder = configBuilder;
    }

    protected void initialize() throws Exception {
        System.out.println("Mule Server starting...");
        if (System.getSecurityManager() == null) {
            // empty if block
        }
        if (configBuilder == null) {
            configBuilder = new MuleXmlConfigurationBuilder();
        }
        if (!configBuilder.isConfigured()) {
            if (this.configurationResources != null) {
                configBuilder.configure(this.configurationResources);
            } else {
                logger.warn((Object)"A configuration file was not set, using default: mule-config.xml");
                configBuilder.configure(DEFAULT_CONFIGURATION);
            }
        }
        System.out.println("Mule Server initialized.");
    }

    void shutdown(Throwable e) {
        logger.fatal((Object)e, e);
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add("A Fatal error has occurred while the server was running-");
        msgs.add(" ");
        msgs.add(e.getMessage() + "[" + e.getClass().getName() + "]");
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            msgs.add("Caused by: " + cause.getMessage() + "[" + cause.getClass().getName() + "]");
        }
        msgs.add("The error is fatal, the system must shutdown.");
        msgs.add("The system was started at : " + new Date(MuleManager.getInstance().getStartDate()));
        msgs.add("The system shutdown at : " + new Date().toString());
        shutdownMessage = StringMessageHelper.getBoilerPlate(msgs, '*', 80);
        logger.fatal((Object)shutdownMessage);
        System.exit(0);
    }

    void shutdown() {
        logger.info((Object)"Mule server shutting dow due to normal shutdown request");
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add("Mule server shutting dow due to normal shutdown request");
        msgs.add("The system was started at : " + new Date(MuleManager.getInstance().getStartDate()));
        msgs.add("The system shutdown at : " + new Date().toString());
        shutdownMessage = StringMessageHelper.getBoilerPlate(msgs, '*', 80);
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

