/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import org.mule.InitialisationException;
import org.mule.util.queue.BoundedPersistentQueue;
import org.mule.util.queue.PersistenceStrategy;

public class QueueProfile {
    private int maxOutstandingMessages = 100;
    private long blockWait = 2000L;
    private PersistenceStrategy persistenceStrategy;

    public QueueProfile() {
    }

    public QueueProfile(int maxOutstandingMessages, PersistenceStrategy persistenceStrategy) {
        this.maxOutstandingMessages = maxOutstandingMessages;
        this.persistenceStrategy = persistenceStrategy;
    }

    public QueueProfile(QueueProfile queueProfile) {
        this.maxOutstandingMessages = queueProfile.getMaxOutstandingMessages();
        this.persistenceStrategy = queueProfile.getPersistenceStrategy();
    }

    public int getMaxOutstandingMessages() {
        return this.maxOutstandingMessages;
    }

    public void setMaxOutstandingMessages(int maxOutstandingMessages) {
        this.maxOutstandingMessages = maxOutstandingMessages;
    }

    public PersistenceStrategy getPersistenceStrategy() {
        return this.persistenceStrategy;
    }

    public void setPersistenceStrategy(PersistenceStrategy persistenceStrategy) {
        this.persistenceStrategy = persistenceStrategy;
    }

    public BoundedPersistentQueue createQueue(String component) throws InitialisationException {
        return new BoundedPersistentQueue(this.maxOutstandingMessages, this.persistenceStrategy, component, true);
    }

    public long getBlockWait() {
        return this.blockWait;
    }

    public void setBlockWait(long blockWait) {
        this.blockWait = blockWait;
    }
}

