/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.InitialisationException;
import org.mule.MuleManager;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOTransactionConfig;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.MuleObjectHelper;

public class EndpointReference {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$config$builders$EndpointReference == null ? (class$org$mule$config$builders$EndpointReference = EndpointReference.class$("org.mule.config.builders.EndpointReference")) : class$org$mule$config$builders$EndpointReference));
    private String propertyName;
    private String endpointName;
    private String address;
    private String transformer;
    private Object object;
    private Map properties;
    private UMOFilter filter;
    private UMOTransactionConfig transactionConfig;
    static /* synthetic */ Class class$org$mule$config$builders$EndpointReference;
    static /* synthetic */ Class class$org$mule$umo$endpoint$UMOEndpoint;

    public EndpointReference(String propertyName, String endpointName, String address, String transformer, Object object) {
        this.propertyName = propertyName;
        this.endpointName = endpointName;
        this.address = address;
        this.transformer = transformer;
        this.object = object;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public Object getObject() {
        return this.object;
    }

    public UMOTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setTransactionConfig(UMOTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UMOFilter filter) {
        this.filter = filter;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void resolveEndpoint() throws InitialisationException {
        try {
            UMOEndpoint ep = MuleManager.getInstance().lookupEndpoint(this.endpointName);
            if (ep == null) {
                throw new InitialisationException("Failed to find Endpoint with name: " + this.endpointName);
            }
            if (this.address != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Overloading endpoint uri for: " + this.endpointName + " from " + ep.getEndpointURI().toString() + " to " + this.address));
                }
                ep.setEndpointURI(new MuleEndpointURI(this.address));
            }
            if (this.transformer != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Overloading Transformer for: " + this.endpointName + " from " + ep.getTransformer() + " to " + this.transformer));
                }
                UMOTransformer trans = MuleObjectHelper.getTransformer(this.transformer, " ");
                ep.setTransformer(trans);
            }
            if (this.filter != null) {
                ep.setFilter(this.filter);
            }
            if (this.properties != null) {
                ep.getProperties().putAll(this.properties);
            }
            if (this.transactionConfig != null) {
                ep.setTransactionConfig(this.transactionConfig);
            }
            ep.initialise();
            Method m = this.object.getClass().getMethod(this.propertyName, class$org$mule$umo$endpoint$UMOEndpoint == null ? (class$org$mule$umo$endpoint$UMOEndpoint = EndpointReference.class$("org.mule.umo.endpoint.UMOEndpoint")) : class$org$mule$umo$endpoint$UMOEndpoint);
            if (m == null) {
                throw new InitialisationException("Method not found: " + this.propertyName + " on " + this.object.getClass().getName());
            }
            m.invoke(this.object, ep);
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitialisationException("Failed to set transformer on bean: " + this.object.getClass().getName() + "." + this.propertyName + "(...).  Error is: " + e.getMessage(), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

