/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.util.Map;
import org.mule.InitialisationException;
import org.mule.MuleManager;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleModel;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.service.ConnectorFactory;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManager;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.model.UMOContainerContext;
import org.mule.umo.provider.UMOConnector;

public class QuickConfigurationBuilder {
    private UMOManager manager;

    public QuickConfigurationBuilder() {
        this.manager = MuleManager.getInstance();
    }

    public QuickConfigurationBuilder(boolean disposeCurrent) throws UMOException {
        if (disposeCurrent) {
            this.disposeCurrent();
        }
        this.manager = MuleManager.getInstance();
    }

    public void disposeCurrent() throws UMOException {
        if (MuleManager.isInstanciated()) {
            MuleManager.getInstance().dispose();
        }
    }

    public UMOManager createStartedManager(boolean synchronous, String serverUrl) throws UMOException {
        if (this.manager.isStarted()) {
            throw new InitialisationException("Manager already started");
        }
        if (serverUrl == null) {
            serverUrl = "";
        }
        MuleManager.getConfiguration().setServerUrl(serverUrl);
        MuleManager.getConfiguration().setSynchronous(synchronous);
        this.manager.setModel(new MuleModel());
        this.manager.start();
        return this.manager;
    }

    public UMOManager createStartedManager(boolean synchronous, String serverUrl, UMOConnector serverConnector) throws UMOException {
        int param;
        if (serverConnector != null) {
            this.manager.registerConnector(serverConnector);
        }
        serverUrl = (param = serverUrl.indexOf("?")) == -1 ? serverUrl + "?" : serverUrl + "&";
        serverUrl = serverUrl + "createConnector=" + serverConnector.getName();
        return this.createStartedManager(synchronous, serverUrl);
    }

    public UMODescriptor registerComponentInstance(Object component, String name, UMOEndpointURI listenerEndpointUri) throws UMOException {
        return this.registerComponentInstance(component, name, listenerEndpointUri, null);
    }

    public UMODescriptor registerComponentInstance(Object component, String name, UMOEndpointURI listenerEndpointUri, UMOEndpointURI sendEndpointUri) throws UMOException {
        MuleDescriptor descriptor = new MuleDescriptor();
        descriptor.setImplementationInstance(component);
        descriptor.setName(name);
        UMOEndpoint inboundProvider = null;
        UMOEndpoint outboundProvider = null;
        if (listenerEndpointUri != null) {
            inboundProvider = ConnectorFactory.createEndpoint(listenerEndpointUri, "receiver");
        }
        if (sendEndpointUri != null) {
            outboundProvider = ConnectorFactory.createEndpoint(sendEndpointUri, "sender");
        }
        descriptor.setInboundEndpoint(inboundProvider);
        descriptor.setOutboundEndpoint(outboundProvider);
        this.manager.getModel().registerComponent(descriptor);
        return descriptor;
    }

    public void registerComponent(UMODescriptor descriptor) throws UMOException {
        this.manager.getModel().registerComponent(descriptor);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri) throws UMOException {
        return this.registerComponent(implementation, name, inboundEndpointUri, null, null);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri, Map properties) throws UMOException {
        return this.registerComponent(implementation, name, inboundEndpointUri, null, properties);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri, UMOEndpointURI outboundEndpointUri) throws UMOException {
        return this.registerComponent(implementation, name, inboundEndpointUri, outboundEndpointUri, null);
    }

    public UMOComponent registerComponent(String implementation, String name, UMOEndpointURI inboundEndpointUri, UMOEndpointURI outboundEndpointUri, Map properties) throws UMOException {
        UMODescriptor d = this.createDescriptor(implementation, name, inboundEndpointUri, outboundEndpointUri, properties);
        return this.manager.getModel().registerComponent(d);
    }

    public UMODescriptor createDescriptor(String implementation, String name, String inboundEndpointUri, String outboundEndpointUri, Map properties) throws UMOException {
        MuleEndpointURI inEndpointUri = null;
        MuleEndpointURI outEndpointUri = null;
        if (inboundEndpointUri != null) {
            inEndpointUri = new MuleEndpointURI(inboundEndpointUri);
        }
        if (outboundEndpointUri != null) {
            outEndpointUri = new MuleEndpointURI(outboundEndpointUri);
        }
        return this.createDescriptor(implementation, name, inEndpointUri, outEndpointUri, properties);
    }

    public UMODescriptor createDescriptor(String implementation, String name, UMOEndpointURI inboundEndpointUri, UMOEndpointURI outboundEndpointUri, Map properties) throws UMOException {
        MuleDescriptor descriptor = new MuleDescriptor();
        descriptor.setImplementation(implementation);
        descriptor.setName(name);
        if (properties != null) {
            descriptor.getProperties().putAll(properties);
        }
        UMOEndpoint inboundProvider = null;
        UMOEndpoint outboundProvider = null;
        if (inboundEndpointUri != null) {
            inboundProvider = ConnectorFactory.createEndpoint(inboundEndpointUri, "receiver");
        }
        if (outboundEndpointUri != null) {
            outboundProvider = ConnectorFactory.createEndpoint(outboundEndpointUri, "sender");
        }
        descriptor.setInboundEndpoint(inboundProvider);
        descriptor.setOutboundEndpoint(outboundProvider);
        return descriptor;
    }

    public void setContainerContext(UMOContainerContext ctx) throws UMOException {
        this.manager.setContainerContext(ctx);
    }

    public void unregisterComponent(String name) throws UMOException {
        UMODescriptor descriptor = this.manager.getModel().getDescriptor(name);
        if (descriptor != null) {
            this.manager.getModel().unregisterComponent(descriptor);
        }
    }
}

