/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.pool;

import org.mule.InitialisationException;
import org.mule.MuleManager;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleProxy;
import org.mule.umo.UMOException;
import org.mule.umo.UMOManager;
import org.mule.util.ClassHelper;
import org.mule.util.ObjectFactory;
import org.mule.util.ObjectPool;

public abstract class AbstractProxyFactory
implements ObjectFactory {
    protected MuleDescriptor descriptor;
    protected ObjectPool pool;

    public AbstractProxyFactory(MuleDescriptor descriptor, ObjectPool pool) {
        this.descriptor = descriptor;
        this.pool = pool;
    }

    public Object create() throws UMOException {
        UMOManager manager = MuleManager.getInstance();
        Object impl = this.descriptor.getImplementation();
        Object component = null;
        if (impl instanceof String) {
            String reference = impl.toString();
            if (reference.startsWith("local:")) {
                String refName = reference.substring("local:".length());
                component = this.descriptor.getProperties().get(refName);
                if (component == null) {
                    throw new InitialisationException("Component implementation type is 'local' but no property called " + refName + " is set on the descriptor called " + this.descriptor.getName());
                }
            }
            if (component == null) {
                if (this.descriptor.isContainerManaged()) {
                    component = manager.getContainerContext().getComponent(reference);
                } else {
                    try {
                        component = ClassHelper.instanciateClass(reference, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new InitialisationException("Failed to instanciate non-container managed object reference: " + reference + ". " + e.getMessage(), e);
                    }
                }
            }
        } else {
            component = impl;
        }
        this.descriptor.fireInitialisationCallbacks(component);
        this.afterComponentCreate(component);
        MuleProxy proxy = new MuleProxy(component, this.descriptor, this.pool);
        return proxy;
    }

    protected void afterComponentCreate(Object component) throws InitialisationException {
    }
}

