/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.pool;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.mule.config.pool.CommonsPoolProxyFactory;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleProxy;
import org.mule.umo.UMOException;
import org.mule.util.ObjectFactory;
import org.mule.util.ObjectPool;

public class CommonsPoolProxyPool
implements ObjectPool {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$config$pool$CommonsPoolProxyPool == null ? (class$org$mule$config$pool$CommonsPoolProxyPool = CommonsPoolProxyPool.class$("org.mule.config.pool.CommonsPoolProxyPool")) : class$org$mule$config$pool$CommonsPoolProxyPool));
    private GenericObjectPool pool;
    private ObjectFactory factory;
    private List components;
    static /* synthetic */ Class class$org$mule$config$pool$CommonsPoolProxyPool;

    public CommonsPoolProxyPool(MuleDescriptor descriptor) {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxIdle = descriptor.getPoolingProfile().getMaxIdle();
        config.maxActive = descriptor.getPoolingProfile().getMaxActive();
        config.maxWait = descriptor.getPoolingProfile().getMaxWait();
        config.whenExhaustedAction = descriptor.getPoolingProfile().getExhaustedAction();
        config.whenExhaustedAction = descriptor.getPoolingProfile().getExhaustedAction();
        this.init(descriptor, config);
    }

    public CommonsPoolProxyPool(MuleDescriptor descriptor, GenericObjectPool.Config config) {
        this.init(descriptor, config);
    }

    private void init(MuleDescriptor descriptor, GenericObjectPool.Config config) {
        this.components = new ArrayList();
        this.setFactory(new CommonsPoolProxyFactory(descriptor, this));
        this.pool = new GenericObjectPool((PoolableObjectFactory)this.factory, config);
    }

    public Object borrowObject() throws Exception {
        return this.pool.borrowObject();
    }

    public void returnObject(Object object) throws Exception {
        this.pool.returnObject(object);
    }

    public int getSize() {
        return this.pool.getNumActive();
    }

    public int getMaxSize() {
        return this.pool.getMaxActive();
    }

    public void setFactory(ObjectFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPool() {
        List list = this.components;
        synchronized (list) {
            MuleProxy proxy = null;
            for (int i = 0; i < this.components.size(); ++i) {
                try {
                    proxy = (MuleProxy)this.components.get(i);
                    proxy.dispose();
                    continue;
                }
                catch (UMOException e) {
                    logger.warn((Object)("failed to dispose object instance: " + proxy.getDescriptor().getName() + ". " + e.getMessage()));
                }
            }
        }
        this.components.clear();
        this.pool.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAdd(Object proxy) {
        List list = this.components;
        synchronized (list) {
            this.components.add(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove(Object proxy) {
        List list = this.components;
        synchronized (list) {
            this.components.remove(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws UMOException {
        List list = this.components;
        synchronized (list) {
            for (int i = 0; i < this.components.size(); ++i) {
                ((MuleProxy)this.components.get(i)).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws UMOException {
        List list = this.components;
        synchronized (list) {
            for (int i = 0; i < this.components.size(); ++i) {
                ((MuleProxy)this.components.get(i)).stop();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

