/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.DefaultExceptionStrategy;
import org.mule.impl.MuleComponent;
import org.mule.impl.RequestContext;
import org.mule.management.stats.ComponentStatistics;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransaction;

public class DefaultComponentExceptionStrategy
extends DefaultExceptionStrategy {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$DefaultComponentExceptionStrategy == null ? (class$org$mule$impl$DefaultComponentExceptionStrategy = DefaultComponentExceptionStrategy.class$("org.mule.impl.DefaultComponentExceptionStrategy")) : class$org$mule$impl$DefaultComponentExceptionStrategy));
    private UMOComponent component;
    private ComponentStatistics statistics;
    static /* synthetic */ Class class$org$mule$impl$DefaultComponentExceptionStrategy;

    public DefaultComponentExceptionStrategy() {
    }

    public DefaultComponentExceptionStrategy(UMOComponent component) {
        this.setComponent(component);
    }

    public UMOComponent getComponent() {
        return this.component;
    }

    public void handleException(Object message, Throwable t) {
        block8: {
            UMOTransaction tx;
            if (this.component == null) {
                UMOEvent event = RequestContext.getEvent();
                if (event == null) {
                    logger.fatal((Object)"The Default Component Exception Strategy has been invoked but there is no current event on the context");
                    logger.fatal((Object)("The error is: " + t.getMessage()), t);
                } else {
                    this.setComponent(event.getComponent());
                }
            }
            if (this.statistics != null) {
                this.statistics.incExecutionError();
            }
            if (this.component != null) {
                logger.error((Object)("Caught exception in Exception Strategy for: " + this.component.getDescriptor().getName() + ": " + t), t);
            }
            if ((tx = TransactionCoordination.getInstance().getTransaction()) != null) {
                this.handleTransaction(tx);
            }
            try {
                this.routeException(message, t);
            }
            catch (UMOException e) {
                logger.fatal((Object)"Failed to route Exception message, this may result in unexpected message loss");
                if (this.statistics == null) break block8;
                this.statistics.incFatalError();
            }
        }
    }

    protected void routeException(Object message, Throwable t) throws UMOException {
        if (this.getEndpoint() != null) {
            super.routeException(message, t);
            this.statistics.getOutboundRouterStat().incrementRoutedMessage(this.getEndpoint());
        }
    }

    public void setComponent(UMOComponent component) {
        this.component = component;
        if (component instanceof MuleComponent) {
            this.statistics = ((MuleComponent)component).getStatistics();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

