/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.RequestContext;
import org.mule.impl.message.ExceptionMessage;
import org.mule.transaction.TransactionCoordination;
import org.mule.transformers.xml.ObjectToXml;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOExceptionStrategy;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.UMOTransactionException;
import org.mule.umo.endpoint.UMOEndpoint;

public class DefaultExceptionStrategy
implements UMOExceptionStrategy {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$DefaultComponentExceptionStrategy == null ? (class$org$mule$impl$DefaultComponentExceptionStrategy = DefaultExceptionStrategy.class$("org.mule.impl.DefaultComponentExceptionStrategy")) : class$org$mule$impl$DefaultComponentExceptionStrategy));
    private UMOEndpoint exceptionEndpoint;
    static /* synthetic */ Class class$org$mule$impl$DefaultComponentExceptionStrategy;

    public UMOEndpoint getEndpoint() {
        return this.exceptionEndpoint;
    }

    public void setEndpoint(UMOEndpoint exceptionEndpoint) {
        this.exceptionEndpoint = exceptionEndpoint;
        if (exceptionEndpoint != null) {
            if (exceptionEndpoint.getTransformer() == null) {
                exceptionEndpoint.setTransformer(new ObjectToXml());
            }
            exceptionEndpoint.setType("sender");
        }
    }

    public void handleException(Object message, Throwable t) {
        logger.error((Object)("Caught exception in Exception Strategy: " + t.getMessage()), t);
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null) {
            this.handleTransaction(tx);
        } else {
            logger.debug((Object)"There is no current transaction to roll back after exception");
        }
        try {
            this.routeException(message, t);
        }
        catch (UMOException e) {
            logger.fatal((Object)("Failed to route Exception message, this may result in unexpected message loss. Endpoint is: " + (this.exceptionEndpoint == null ? null : this.exceptionEndpoint.getEndpointURI())));
        }
    }

    protected void routeException(Object message, Throwable t) throws UMOException {
        if (this.exceptionEndpoint != null) {
            logger.error((Object)("Message being processed is: " + (message == null ? "null" : message.toString())));
            UMOEventContext ctx = RequestContext.getEventContext();
            ExceptionMessage msg = new ExceptionMessage(message, t, ctx);
            ctx.dispatchEvent((UMOMessage)msg, this.exceptionEndpoint);
            logger.debug((Object)("routed Exception message via " + this.exceptionEndpoint));
        }
    }

    protected void handleTransaction(UMOTransaction tx) {
        logger.warn((Object)("Marking current transaction for rollback: " + tx));
        try {
            tx.setRollbackOnly();
        }
        catch (UMOTransactionException e) {
            logger.error((Object)"Could not mark transaction for rollback", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

