/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.InitialisationException;
import org.mule.MuleException;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.UMODescriptorAware;
import org.mule.model.DynamicEntryPoint;
import org.mule.model.DynamicEntryPointResolver;
import org.mule.umo.Invocation;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.Startable;
import org.mule.umo.lifecycle.Stoppable;
import org.mule.umo.lifecycle.UMOLifecycleAdapter;
import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.util.ClassHelper;

public class DefaultLifecycleAdapter
implements UMOLifecycleAdapter {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$DefaultLifecycleAdapter == null ? (class$org$mule$impl$DefaultLifecycleAdapter = DefaultLifecycleAdapter.class$("org.mule.impl.DefaultLifecycleAdapter")) : class$org$mule$impl$DefaultLifecycleAdapter));
    private Object component;
    private UMODescriptor descriptor;
    private boolean isStoppable = false;
    private boolean isStartable = false;
    private boolean isDisposable = false;
    private boolean started = false;
    private boolean disposed = false;
    private DynamicEntryPoint entryPoint;
    private Object lock = new Object();
    static /* synthetic */ Class class$org$mule$impl$DefaultLifecycleAdapter;
    static /* synthetic */ Class class$org$mule$umo$lifecycle$Startable;
    static /* synthetic */ Class class$org$mule$umo$lifecycle$Stoppable;
    static /* synthetic */ Class class$org$mule$umo$lifecycle$Disposable;
    static /* synthetic */ Class class$org$mule$umo$lifecycle$Initialisable;

    public DefaultLifecycleAdapter(Object component, UMODescriptor descriptor) throws UMOException {
        this(component, descriptor, new DynamicEntryPointResolver());
    }

    public DefaultLifecycleAdapter(Object component, UMODescriptor descriptor, UMOEntryPointResolver epResolver) throws UMOException {
        this.initialise(component, descriptor, epResolver);
    }

    protected void initialise(Object component, UMODescriptor descriptor, UMOEntryPointResolver epDiscovery) throws UMOException {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor cannot be null");
        }
        if (epDiscovery == null) {
            epDiscovery = new DynamicEntryPointResolver();
        }
        this.component = component;
        this.entryPoint = (DynamicEntryPoint)epDiscovery.resolveEntryPoint(descriptor);
        this.descriptor = descriptor;
        this.isStartable = (class$org$mule$umo$lifecycle$Startable == null ? (class$org$mule$umo$lifecycle$Startable = DefaultLifecycleAdapter.class$("org.mule.umo.lifecycle.Startable")) : class$org$mule$umo$lifecycle$Startable).isInstance(component);
        this.isStoppable = (class$org$mule$umo$lifecycle$Stoppable == null ? (class$org$mule$umo$lifecycle$Stoppable = DefaultLifecycleAdapter.class$("org.mule.umo.lifecycle.Stoppable")) : class$org$mule$umo$lifecycle$Stoppable).isInstance(component);
        this.isDisposable = (class$org$mule$umo$lifecycle$Disposable == null ? (class$org$mule$umo$lifecycle$Disposable = DefaultLifecycleAdapter.class$("org.mule.umo.lifecycle.Disposable")) : class$org$mule$umo$lifecycle$Disposable).isInstance(component);
        if (component instanceof UMODescriptorAware) {
            ((UMODescriptorAware)component).setDescriptor(descriptor);
        }
    }

    public void start() throws UMOException {
        if (this.isStartable) {
            try {
                ((Startable)this.component).start();
            }
            catch (Exception e) {
                throw new MuleException("Failed to start Mule UMO: " + this.descriptor.getName(), e);
            }
        }
        this.started = true;
    }

    public void stop() throws UMOException {
        if (this.isStoppable) {
            try {
                ((Stoppable)this.component).stop();
            }
            catch (Exception e) {
                throw new MuleException("Failed to stop Mule UMO: " + this.descriptor.getName(), e);
            }
        }
        this.started = false;
    }

    public void dispose() throws UMOException {
        if (this.isDisposable) {
            try {
                ((Disposable)this.component).dispose();
            }
            catch (Exception e) {
                throw new MuleException("Failed to dispose Mule UMO: " + this.descriptor.getName(), e);
            }
        }
        this.disposed = true;
    }

    public Object onCall(UMOEvent event) throws UMOException {
        Object result = null;
        try {
            Object methodOverride = event.removeProperty("MULE_METHOD");
            Method method = null;
            if (methodOverride instanceof Method) {
                method = (Method)methodOverride;
            } else if (methodOverride != null) {
                method = ClassHelper.getMethod(methodOverride.toString(), this.component.getClass());
            }
            result = this.entryPoint.invoke(this.component, RequestContext.getEventContext(), method);
            if (result == null && this.entryPoint.isVoid()) {
                return new MuleMessage(event.getTransformedMessage(), event.getProperties());
            }
            if (this.descriptor.getResponseRouter() != null) {
                logger.debug((Object)"Waiting for response router message");
                result = result == null ? this.descriptor.getResponseRouter().getResponse(event.getMessage()) : this.descriptor.getResponseRouter().getResponse(new MuleMessage(result, event.getProperties()));
                if (this.descriptor.getResponseRouter().isStopProcessing()) {
                    RequestContext.getEvent().setStopFurtherProcessing(true);
                }
                return result;
            }
            return result;
        }
        catch (Exception e) {
            throw new MuleException("Failed to invoke event: " + e.getMessage(), e);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public UMODescriptor getDescriptor() {
        return this.descriptor;
    }

    public void handleException(Object message, Throwable t) {
        this.descriptor.getExceptionStrategy().handleException(message, t);
    }

    public UMOMessage intercept(Invocation invocation) throws UMOException {
        UMOEvent currentEvent = RequestContext.getEvent();
        Object result = this.onCall(currentEvent);
        if (result instanceof UMOMessage) {
            return (UMOMessage)result;
        }
        if (result instanceof UMOEvent) {
            return ((UMOEvent)result).getMessage();
        }
        if (result != null) {
            return new MuleMessage(result, currentEvent.getProperties());
        }
        return null;
    }

    public void initialise() throws InitialisationException {
        if ((class$org$mule$umo$lifecycle$Initialisable == null ? (class$org$mule$umo$lifecycle$Initialisable = DefaultLifecycleAdapter.class$("org.mule.umo.lifecycle.Initialisable")) : class$org$mule$umo$lifecycle$Initialisable).isInstance(this.component)) {
            ((Initialisable)this.component).initialise();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

