/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.routing.filters.EqualsFilter;
import org.mule.routing.filters.WildcardFilter;
import org.mule.umo.UMOFilter;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOImmutableEndpoint;

public class EndpointList {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$EndpointList == null ? (class$org$mule$impl$EndpointList = EndpointList.class$("org.mule.impl.EndpointList")) : class$org$mule$impl$EndpointList));
    private Map sendProviders = new HashMap();
    private Map receiveProviders = new HashMap();
    private String defaultSend = null;
    private String defaultReceive = null;
    static /* synthetic */ Class class$org$mule$impl$EndpointList;

    public Iterator getReceiverNames() {
        return this.receiveProviders.keySet().iterator();
    }

    public Iterator getSenderNames() {
        return this.sendProviders.keySet().iterator();
    }

    public UMOEndpoint getReceiveProvider(String name) {
        UMOImmutableEndpoint endpoint = (UMOImmutableEndpoint)this.receiveProviders.get(name);
        if (endpoint == null) {
            return null;
        }
        return new MuleEndpoint(endpoint);
    }

    public UMOEndpoint getSendProvider(String name) {
        UMOImmutableEndpoint endpoint = (UMOImmutableEndpoint)this.sendProviders.get(name);
        if (endpoint == null) {
            return null;
        }
        return new MuleEndpoint(endpoint);
    }

    public void addSendProvider(UMOImmutableEndpoint endpoint, boolean readOnly) {
        if (this.sendProviders.isEmpty()) {
            this.defaultSend = endpoint.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Default Send endpoint has been set to: " + this.defaultSend));
            }
        }
        endpoint = this.configure(endpoint, readOnly, true);
        this.sendProviders.put(endpoint.getName(), endpoint);
        logger.debug((Object)("Added Send endpoint: " + endpoint.getName()));
    }

    public void addProviderList(EndpointList list) {
        Iterator iterator = list.getAll().values().iterator();
        while (iterator.hasNext()) {
            UMOImmutableEndpoint endpoint = (UMOImmutableEndpoint)iterator.next();
            this.add(endpoint);
        }
    }

    protected void addReceiveProvider(UMOImmutableEndpoint endpoint, boolean readOnly) {
        if (this.receiveProviders.isEmpty()) {
            this.defaultReceive = endpoint.getName();
            endpoint = this.configure(endpoint, readOnly, false);
        }
        this.receiveProviders.put(endpoint.getName(), endpoint);
        logger.debug((Object)("Added Receive endpoint: " + endpoint.getName()));
    }

    public void setDefaultSendProvider(UMOImmutableEndpoint endpoint) throws MuleException {
        this.setDefaultSendProvider(endpoint, false);
    }

    public void setDefaultSendProvider(UMOImmutableEndpoint endpoint, boolean readOnly) throws MuleException {
        UMOImmutableEndpoint p;
        if (endpoint == null) {
            throw new MuleException("The endpoint argument is null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting the Default Send endpoint to: " + endpoint.getName()));
        }
        if ((p = (UMOImmutableEndpoint)this.sendProviders.get(endpoint.getName())) != null) {
            endpoint = p;
            this.sendProviders.remove(endpoint.getName());
        }
        endpoint = this.configure(endpoint, readOnly, true);
        this.addSendProvider(endpoint, readOnly);
        this.defaultSend = endpoint.getName();
    }

    public void setDefaultReceiveProvider(UMOImmutableEndpoint endpoint) throws MuleException {
        this.setDefaultReceiveProvider(endpoint, false);
    }

    public void setDefaultReceiveProvider(UMOImmutableEndpoint endpoint, boolean readOnly) throws MuleException {
        if (endpoint == null) {
            throw new MuleException("The endpoint argument is null");
        }
        logger.info((Object)("Setting the Default Send endpoint to: " + endpoint.getName()));
        MuleEndpoint p = (MuleEndpoint)this.receiveProviders.get(endpoint.getName());
        if (p != null) {
            endpoint = p;
            this.receiveProviders.remove(endpoint.getName());
        }
        endpoint = this.configure(endpoint, readOnly, false);
        this.addReceiveProvider(endpoint, readOnly);
        this.defaultReceive = endpoint.getName();
    }

    public UMOImmutableEndpoint getDefaultReceiveProvider() {
        return (UMOImmutableEndpoint)this.receiveProviders.get(this.defaultReceive);
    }

    public UMOImmutableEndpoint getDefaultSendProvider() {
        return (UMOImmutableEndpoint)this.sendProviders.get(this.defaultSend);
    }

    public int getSendProvidersSize() {
        return this.sendProviders.size();
    }

    public int getReceiveProvidersSize() {
        return this.receiveProviders.size();
    }

    public void add(UMOImmutableEndpoint endpoint) {
        this.add(endpoint, false);
    }

    public void add(UMOImmutableEndpoint endpoint, boolean readOnly) {
        if (endpoint == null) {
            return;
        }
        if (endpoint.getType().equals("receiver")) {
            endpoint = this.configure(endpoint, readOnly, false);
            this.addReceiveProvider(endpoint, readOnly);
        } else if (endpoint.getType().equals("sender") || endpoint.getType().equals("senderAndReceiver")) {
            endpoint = this.configure(endpoint, readOnly, true);
            this.addSendProvider(endpoint, readOnly);
        } else {
            throw new IllegalArgumentException("Provider type not recognised: " + endpoint.getType());
        }
    }

    public UMOEndpoint get(String name) {
        if (name == null) {
            return null;
        }
        UMOEndpoint endpoint = this.getSendProvider(name);
        if (endpoint == null) {
            endpoint = this.getReceiveProvider(name);
        }
        return endpoint;
    }

    public void remove(UMOImmutableEndpoint endpoint) {
        if (endpoint == null) {
            return;
        }
        if (endpoint.getType().equals("receiver")) {
            logger.debug((Object)("Removing Receive endpoint: " + endpoint.getName()));
            this.receiveProviders.remove(endpoint.getName());
        } else if (endpoint.getType().equals("sender")) {
            logger.debug((Object)("Removing Send endpoint: " + endpoint.getName()));
            this.sendProviders.remove(endpoint.getName());
        } else if (endpoint.getType().equals("senderAndReceiver")) {
            logger.debug((Object)("Removing Send and Receive endpoint: " + endpoint.getName()));
            this.receiveProviders.remove(endpoint.getName());
            this.sendProviders.remove(endpoint.getName());
        } else {
            logger.warn((Object)("Provider type is notrecognised, type is: " + endpoint.getType()));
        }
    }

    public int getTotalSize() {
        return this.getSendProvidersSize() + this.getReceiveProvidersSize();
    }

    public UMOImmutableEndpoint[] getReceiveProvidersByProtocol(String protocol) {
        return this.getProvidersByProtocol(this.receiveProviders, protocol);
    }

    public MuleEndpoint[] getSendProvidersByProtocol(String protocol) {
        return this.getProvidersByProtocol(this.sendProviders, protocol);
    }

    private MuleEndpoint[] getProvidersByProtocol(Map endpoints, String protocol) {
        Map.Entry entry = null;
        ArrayList list = new ArrayList();
        Iterator i = endpoints.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            if (!((UMOEndpoint)entry.getValue()).getProtocol().equalsIgnoreCase(protocol)) continue;
            list.add(entry.getValue());
        }
        return list.toArray(new MuleEndpoint[list.size()]);
    }

    private MuleEndpoint[] getEndpointByUri(Map endpoints, String endpointUri, boolean wildcardMatch) {
        UMOFilter filter = wildcardMatch ? new WildcardFilter(endpointUri) : new EqualsFilter(endpointUri);
        Map.Entry entry = null;
        ArrayList list = new ArrayList();
        Iterator i = endpoints.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            UMOEndpoint endpoint = (UMOEndpoint)entry.getValue();
            if (!filter.accept(endpoint.getEndpointURI())) continue;
            list.add(entry.getValue());
        }
        return list.toArray(new MuleEndpoint[list.size()]);
    }

    public UMOImmutableEndpoint[] getReceiveProvidersByEndpoint(String endpoint, boolean exactMatch) {
        return this.getEndpointByUri(this.receiveProviders, endpoint, exactMatch);
    }

    public MuleEndpoint[] getSendProvidersByEndpoint(String endpoint, boolean exactMatch) {
        return this.getEndpointByUri(this.sendProviders, endpoint, exactMatch);
    }

    private UMOImmutableEndpoint configure(UMOImmutableEndpoint endpoint, boolean readOnly, boolean isSender) {
        MuleEndpoint configuredProvider = endpoint instanceof UMOImmutableEndpoint ? new MuleEndpoint(endpoint) : (MuleEndpoint)endpoint;
        if (isSender) {
            configuredProvider.setType("sender");
        } else {
            configuredProvider.setType("receiver");
        }
        if (readOnly) {
            return configuredProvider.getImmutableProvider();
        }
        return configuredProvider;
    }

    public void clear() {
        this.receiveProviders.clear();
        this.sendProviders.clear();
    }

    public Map getAll() {
        HashMap all = new HashMap(this.receiveProviders);
        all.putAll(this.sendProviders);
        return Collections.unmodifiableMap(all);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

