/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.InitialisationException;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.QueueProfile;
import org.mule.config.ThreadingProfile;
import org.mule.impl.DefaultComponentExceptionStrategy;
import org.mule.impl.FailedToQueueEventException;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleModel;
import org.mule.impl.MuleProxy;
import org.mule.impl.internal.events.ComponentEvent;
import org.mule.management.stats.ComponentStatistics;
import org.mule.umo.ComponentException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOExceptionStrategy;
import org.mule.umo.UMOMessage;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.util.ObjectPool;
import org.mule.util.queue.BoundedPersistentQueue;

public final class MuleComponent
implements UMOComponent {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$MuleComponent == null ? (class$org$mule$impl$MuleComponent = MuleComponent.class$("org.mule.impl.MuleComponent")) : class$org$mule$impl$MuleComponent));
    private MuleDescriptor descriptor = null;
    private PooledExecutor threadPool = null;
    private ObjectPool proxyPool = null;
    private BoundedPersistentQueue queue;
    private ComponentStatistics stats = null;
    private SynchronizedBoolean stopped = new SynchronizedBoolean(true);
    private SynchronizedBoolean stopping = new SynchronizedBoolean(false);
    private SynchronizedBoolean paused = new SynchronizedBoolean(false);
    private SynchronizedBoolean poolInitialised = new SynchronizedBoolean(false);
    private Thread worker = null;
    private QueueProfile qProfile;
    private UMOExceptionStrategy exceptionStrategy = null;
    private SynchronizedBoolean initialised = new SynchronizedBoolean(false);
    private MuleModel model;
    static /* synthetic */ Class class$org$mule$impl$MuleComponent;

    public MuleComponent(MuleDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor cannot be null");
        }
        this.descriptor = descriptor;
        this.model = (MuleModel)MuleManager.getInstance().getModel();
    }

    public synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            throw new InitialisationException("Component: " + this.descriptor.getName() + " has already bean initialised");
        }
        this.descriptor.initialise();
        this.exceptionStrategy = this.descriptor.getExceptionStrategy();
        this.stats = new ComponentStatistics(this.getName(), this.descriptor.getPoolingProfile().getMaxActive(), this.descriptor.getThreadingProfile().getMaxThreadsActive());
        this.stats.setEnabled(((MuleManager)MuleManager.getInstance()).getStatistics().isEnabled());
        ((MuleManager)MuleManager.getInstance()).getStatistics().add(this.stats);
        this.stats.setOutboundRouterStat(this.getDescriptor().getOutboundRouter().getStatistics());
        this.stats.setInboundRouterStat(this.getDescriptor().getInboundRouter().getStatistics());
        ThreadingProfile tp = this.descriptor.getThreadingProfile();
        this.threadPool = tp.createPool(this.descriptor.getName());
        try {
            this.queue = this.descriptor.getQueueProfile().createQueue(this.descriptor.getName());
            this.queue.setDeleteOnTake(false);
            this.qProfile = this.descriptor.getQueueProfile();
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InitialisationException("Failed to component queue: " + e.getMessage(), e);
        }
        this.initialised.set(true);
        this.model.fireEvent(new ComponentEvent(this.descriptor, 301));
    }

    private void initialisePool() throws InitialisationException {
        try {
            this.proxyPool = this.descriptor.getPoolingProfile().getPoolFactory().createPool(this.descriptor);
            if (this.descriptor.getPoolingProfile().getInitialisationPolicy() == 2) {
                int i;
                ArrayList<Object> components = new ArrayList<Object>();
                int threads = this.descriptor.getPoolingProfile().getMaxActive();
                for (i = 0; i < threads; ++i) {
                    components.add(this.proxyPool.borrowObject());
                }
                for (i = 0; i < threads; ++i) {
                    this.proxyPool.returnObject(components.remove(0));
                }
            } else if (this.descriptor.getPoolingProfile().getInitialisationPolicy() == 1) {
                this.proxyPool.returnObject(this.proxyPool.borrowObject());
            }
            this.poolInitialised.set(true);
        }
        catch (Exception e) {
            throw new InitialisationException("Mule proxy pool failed to initialise: " + e, e);
        }
    }

    void finaliseEvent(UMOEvent event) {
        logger.debug((Object)("Finalising event for: " + this.descriptor.getName() + " event endpointUri is: " + event.getEndpoint().getEndpointURI()));
        this.queue.remove(event);
    }

    public void stop() throws UMOException {
        if (!this.stopped.get()) {
            logger.debug((Object)"Stopping UMOComponent");
            this.stopping.set(true);
            try {
                this.proxyPool.stop();
            }
            catch (Exception e) {
                throw new ComponentException("Failed to start component", this, e);
            }
            if (this.worker != null) {
                try {
                    this.worker.interrupt();
                    this.worker = null;
                }
                catch (Exception e) {
                    logger.error((Object)("Component worker thread did not close properly: " + e));
                }
            }
            this.stopped.set(true);
            this.stopping.set(false);
            this.model.fireEvent(new ComponentEvent(this.descriptor, 303));
        }
    }

    public void start() throws UMOException {
        if (this.stopped.get()) {
            this.stopped.set(false);
            try {
                if (!this.poolInitialised.get()) {
                    this.initialisePool();
                }
                this.proxyPool.start();
                this.worker = new Thread((Runnable)this, this.descriptor.getName() + ".component");
                this.worker.setPriority(5);
                this.worker.start();
            }
            catch (Exception e) {
                throw new ComponentException("Failed to start proxy pool", this, e);
            }
        }
        this.model.fireEvent(new ComponentEvent(this.descriptor, 302));
    }

    public void pause() {
        this.paused.set(true);
        this.model.fireEvent(new ComponentEvent(this.descriptor, 304));
    }

    public void resume() {
        this.paused.set(false);
        this.model.fireEvent(new ComponentEvent(this.descriptor, 305));
    }

    public void dispose() throws UMOException {
        if (!this.stopped.get()) {
            this.stop();
        }
        try {
            if (this.queue != null) {
                this.queue.dispose();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Persistent Queue did not close properly: " + e));
        }
        try {
            if (this.threadPool != null) {
                this.threadPool.shutdownNow();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Component Thread Pool did not close properly: " + e));
        }
        try {
            if (this.proxyPool != null) {
                this.proxyPool.clearPool();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Proxy Pool did not close properly: " + e));
        }
        this.model.fireEvent(new ComponentEvent(this.descriptor, 306));
    }

    public ComponentStatistics getStatistics() {
        return this.stats;
    }

    public UMODescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(UMOEvent event) throws UMOException {
        if (!event.getEndpoint().canReceive()) {
            UMOMessageDispatcher dispatcher = event.getEndpoint().getConnector().getDispatcher(event.getEndpoint().getEndpointURI().getAddress());
            try {
                dispatcher.dispatch(event);
            }
            catch (Exception e) {
                throw new DispatchException(e.getMessage(), e);
            }
            return;
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventASync();
        }
        logger.debug((Object)("Component: " + this.descriptor.getName() + " has received asynchronous event on: " + event.getEndpoint().getEndpointURI()));
        if (this.queue.size() >= this.qProfile.getMaxOutstandingMessages()) {
            logger.trace((Object)("process maxQueueSize reached:" + this.qProfile.getMaxOutstandingMessages()));
            while (this.queue.size() >= this.qProfile.getMaxOutstandingMessages()) {
                BoundedPersistentQueue dispatcher = this.queue;
                synchronized (dispatcher) {
                    try {
                        Thread.yield();
                        this.queue.wait(this.qProfile.getBlockWait());
                    }
                    catch (Exception ie) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            this.queue.put(event);
            if (this.stats.isEnabled()) {
                this.stats.incQueuedEvent();
            }
        }
        catch (InterruptedException e) {
            FailedToQueueEventException e1 = new FailedToQueueEventException("Interrupted while queue event for: " + this.getName(), e);
            this.handleException(event, e1);
        }
        logger.trace((Object)("Event added to queue for: " + this.descriptor.getName()));
    }

    public UMOMessage sendEvent(UMOEvent event) throws UMOException {
        while (this.paused.get()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Component: " + this.descriptor.getName() + " is paused. Blocking call until resume is called"));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventSync();
        }
        logger.debug((Object)("Component: " + this.descriptor.getName() + " has received synchronous event on: " + event.getEndpoint().getEndpointURI()));
        UMOMessage result = null;
        MuleProxy proxy = null;
        try {
            proxy = (MuleProxy)this.proxyPool.borrowObject();
            this.getStatistics().setComponentPoolSize(this.proxyPool.getSize());
            proxy.setStatistics(this.getStatistics());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + " : got proxy for " + event.getId() + " = " + proxy));
            }
            result = (UMOMessage)proxy.onCall(event);
            this.proxyPool.returnObject(proxy);
        }
        catch (Exception e) {
            try {
                this.proxyPool.returnObject(proxy);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (e instanceof MuleException) {
                throw (MuleException)e;
            }
            throw new MuleException("Failed to send event through session: " + e, e);
        }
        return result;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    ObjectPool getProxyPool() {
        return this.proxyPool;
    }

    public String toString() {
        return this.descriptor.getName();
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public void run() {
        MuleEvent event = null;
        MuleProxy proxy = null;
        while (!this.stopped.get() && !this.stopping.get()) {
            if (this.paused.get()) continue;
            try {
                event = (MuleEvent)this.queue.take();
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.stats.isEnabled()) {
                this.stats.decQueuedEvent();
            }
            if (event == null) continue;
            logger.debug((Object)("Component: " + this.descriptor.getName() + " dequeued event on: " + event.getEndpoint().getEndpointURI()));
            try {
                proxy = (MuleProxy)this.proxyPool.borrowObject();
                this.getStatistics().setComponentPoolSize(this.proxyPool.getSize());
                proxy.setStatistics(this.getStatistics());
            }
            catch (NoSuchElementException e) {
                this.handleException(event, new ComponentException("Proxy pool timed out. " + e, this, e));
            }
            catch (Exception e) {
                this.handleException(event, new ComponentException("Failed to borrow object from pool: " + e.getMessage(), this, e));
            }
            if (proxy == null) {
                this.handleException(event, new ComponentException("No proxy was found", this));
            }
            if (!proxy.isStarted()) {
                try {
                    proxy.start();
                }
                catch (UMOException e) {
                    this.handleException(event, e);
                }
            }
            proxy.onEvent(event);
            try {
                this.threadPool.execute((Runnable)proxy);
            }
            catch (InterruptedException e) {
                this.handleException(event, e);
            }
        }
    }

    protected void handleException(Object msg, Throwable t) {
        if (this.exceptionStrategy instanceof DefaultComponentExceptionStrategy && ((DefaultComponentExceptionStrategy)this.exceptionStrategy).getComponent() == null) {
            ((DefaultComponentExceptionStrategy)this.exceptionStrategy).setComponent(this);
        }
        this.exceptionStrategy.handleException(msg, t);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

