/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.InitialisationException;
import org.mule.MuleException;
import org.mule.impl.DefaultComponentExceptionStrategy;
import org.mule.impl.DefaultLifecycleAdapterFactory;
import org.mule.impl.MuleComponent;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleSession;
import org.mule.impl.internal.events.ModelEvent;
import org.mule.impl.internal.events.ServerEventManager;
import org.mule.model.DynamicEntryPointResolver;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOExceptionStrategy;
import org.mule.umo.UMOServerEvent;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.UMOLifecycleAdapterFactory;
import org.mule.umo.model.ModelException;
import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.umo.model.UMOModel;

public class MuleModel
implements UMOModel {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$MuleModel == null ? (class$org$mule$impl$MuleModel = MuleModel.class$("org.mule.impl.MuleModel")) : class$org$mule$impl$MuleModel));
    private String name = "mule";
    private UMOEntryPointResolver entryPointResolver;
    private UMOLifecycleAdapterFactory lifecycleAdapterFactory;
    private ConcurrentHashMap components;
    protected ConcurrentHashMap descriptors;
    private SynchronizedBoolean initialised = new SynchronizedBoolean(false);
    private SynchronizedBoolean started = new SynchronizedBoolean(false);
    private UMOExceptionStrategy exceptionStrategy;
    private ServerEventManager listeners;
    static /* synthetic */ Class class$org$mule$impl$MuleModel;

    public MuleModel() {
        this.entryPointResolver = new DynamicEntryPointResolver();
        this.lifecycleAdapterFactory = new DefaultLifecycleAdapterFactory();
        this.components = new ConcurrentHashMap();
        this.descriptors = new ConcurrentHashMap();
        this.exceptionStrategy = new DefaultComponentExceptionStrategy();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UMOEntryPointResolver getEntryPointResolver() {
        return this.entryPointResolver;
    }

    public void setEntryPointResolver(UMOEntryPointResolver entryPointResolver) {
        this.entryPointResolver = entryPointResolver;
    }

    public boolean isComponentRegistered(String name) {
        return this.components.get((Object)name) != null;
    }

    public UMOComponent registerComponent(UMODescriptor descriptor) throws UMOException {
        UMOComponent component;
        if (descriptor == null) {
            throw new MuleException("Mule UMO descriptor to register was null");
        }
        if (descriptor.getExceptionStrategy() == null) {
            descriptor.setExceptionStrategy(this.exceptionStrategy);
        }
        if ((component = (UMOComponent)this.components.get((Object)descriptor.getName())) == null) {
            component = new MuleComponent((MuleDescriptor)descriptor);
            this.descriptors.put((Object)descriptor.getName(), (Object)descriptor);
            this.components.put((Object)descriptor.getName(), (Object)component);
        }
        logger.debug((Object)("Added Mule UMO: " + descriptor.getName()));
        if (this.initialised.get()) {
            try {
                logger.info((Object)("Initialising component: " + descriptor.getName()));
                component.initialise();
            }
            catch (Exception e) {
                throw new InitialisationException("Failed to start component: " + descriptor.getName() + ". Error is: " + e.getMessage(), e);
            }
        }
        if (this.started.get()) {
            logger.info((Object)("Starting component: " + descriptor.getName()));
            this.registerListeners(component);
            component.start();
        }
        return component;
    }

    public void unregisterComponent(UMODescriptor descriptor) throws UMOException {
        if (descriptor == null) {
            throw new ModelException("Mule UMO descriptor to unregister was null");
        }
        if (!this.isComponentRegistered(descriptor.getName())) {
            throw new ModelException("Component not registered: " + descriptor.getName());
        }
        UMOComponent component = (UMOComponent)this.components.remove((Object)descriptor.getName());
        if (component == null) {
            throw new MuleException("component: " + descriptor.getName() + "is not registered with this model");
        }
        component.stop();
        this.unregisterListeners(component);
        this.descriptors.remove((Object)descriptor.getName());
        component.dispose();
        logger.info((Object)("The component: " + descriptor.getName() + " has been unregistered and disposing"));
    }

    protected void registerListeners(UMOComponent component) throws UMOException {
        ArrayList<UMOEndpoint> endpoints = new ArrayList<UMOEndpoint>();
        endpoints.addAll(component.getDescriptor().getInboundRouter().getEndpoints());
        if (component.getDescriptor().getInboundEndpoint() != null) {
            endpoints.add(component.getDescriptor().getInboundEndpoint());
        }
        if (component.getDescriptor().getResponseRouter() != null && component.getDescriptor().getResponseRouter().getEndpoints() != null) {
            endpoints.addAll(component.getDescriptor().getResponseRouter().getEndpoints());
        }
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            try {
                endpoint.getConnector().registerListener(component, endpoint);
            }
            catch (Exception e) {
                throw new MuleException("Failed to register Component: " + component.getDescriptor().getName() + " as a listener on connector: " + endpoint.getConnector().getName() + ". Error is: " + e, e);
            }
        }
    }

    protected void unregisterListeners(UMOComponent component) throws UMOException {
        List endpoints = component.getDescriptor().getInboundRouter().getEndpoints();
        if (component.getDescriptor().getInboundEndpoint() != null) {
            endpoints.add(component.getDescriptor().getInboundEndpoint());
        }
        Iterator it = endpoints.iterator();
        while (it.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)it.next();
            try {
                endpoint.getConnector().unregisterListener(component, endpoint);
            }
            catch (Exception e) {
                throw new MuleException("Failed to unregister Component: " + component.getDescriptor().getName() + " as a listener on connector: " + endpoint.getConnector().getName() + ". Error is: " + e, e);
            }
        }
    }

    public UMOLifecycleAdapterFactory getLifecycleAdapterFactory() {
        return this.lifecycleAdapterFactory;
    }

    public void setLifecycleAdapterFactory(UMOLifecycleAdapterFactory lifecycleAdapterFactory) {
        this.lifecycleAdapterFactory = lifecycleAdapterFactory;
    }

    public void dispose() throws UMOException {
        this.fireEvent(new ModelEvent(this, 209));
        UMOComponent temp = null;
        Object key = null;
        Iterator i = this.components.keySet().iterator();
        while (i.hasNext()) {
            try {
                key = i.next();
                temp = (UMOComponent)this.components.get(key);
                try {
                    temp.dispose();
                }
                catch (Exception e1) {
                    logger.warn((Object)("Failed to dispose component: " + e1.getMessage()));
                }
                this.components.remove((Object)temp.getDescriptor());
                logger.info((Object)(temp + " has been destroyed successfully"));
            }
            catch (ConcurrentModificationException e) {
                logger.warn((Object)"cannot dispose calling component");
                return;
            }
        }
        this.fireEvent(new ModelEvent(this, 210));
    }

    public UMOSession getComponentSession(String muleName) {
        UMOComponent component = (UMOComponent)this.components.get((Object)muleName);
        if (component == null) {
            logger.warn((Object)("Component: " + muleName + " not found returning null session"));
            return null;
        }
        return new MuleSession(component, TransactionCoordination.getInstance().getTransaction());
    }

    public void stop() throws UMOException {
        this.fireEvent(new ModelEvent(this, 207));
        UMOComponent temp = null;
        Iterator i = this.components.values().iterator();
        while (i.hasNext()) {
            temp = (UMOComponent)i.next();
            try {
                temp.stop();
            }
            catch (Exception e) {
                throw new MuleException("Failed to stop Component: " + e.getMessage(), e);
            }
            logger.info((Object)("Component " + temp + " has been stopped successfully"));
        }
        this.fireEvent(new ModelEvent(this, 208));
    }

    public void start() throws UMOException {
        if (!this.initialised.get()) {
            try {
                this.initialise();
            }
            catch (Exception e) {
                throw new InitialisationException("Failed to initialise Model: " + e.getMessage(), e);
            }
        }
        if (!this.started.get()) {
            this.fireEvent(new ModelEvent(this, 205));
            UMOComponent temp = null;
            Iterator i = this.components.values().iterator();
            while (i.hasNext()) {
                temp = (UMOComponent)i.next();
                try {
                    this.registerListeners(temp);
                    temp.start();
                }
                catch (Exception e) {
                    throw new MuleException("Failed to start component: " + e.getMessage(), e);
                }
                logger.info((Object)("Component " + temp + " has been started successfully"));
            }
            this.started.set(true);
            this.fireEvent(new ModelEvent(this, 206));
        } else {
            logger.debug((Object)"Model already started");
        }
    }

    public void stopComponent(String name) throws UMOException {
        UMOComponent component = (UMOComponent)this.components.get((Object)name);
        if (component == null) {
            throw new ModelException("Cannot find Mule Component " + name);
        }
        try {
            this.unregisterListeners(component);
            component.stop();
        }
        catch (Exception e) {
            throw new MuleException("Failed to stop Mule session: " + name, e);
        }
        logger.info((Object)("mule " + name + " has been stopped successfully"));
    }

    public void startComponent(String name) throws UMOException {
        UMOComponent component = (UMOComponent)this.components.get((Object)name);
        if (component == null) {
            throw new MuleException("Cannot find mule " + name);
        }
        try {
            this.registerListeners(component);
            component.start();
        }
        catch (Exception e) {
            throw new MuleException("Failed to start Mule Component: " + name, e);
        }
        logger.info((Object)("Mule " + component.toString() + " has been started successfully"));
    }

    public void pauseComponent(String name) throws UMOException {
        UMOComponent component = (UMOComponent)this.components.get((Object)name);
        if (component == null) {
            throw new MuleException("Cannot find Mule Component " + name);
        }
        try {
            component.pause();
        }
        catch (Exception e) {
            throw new MuleException("Failed to stop Mule session: " + name, e);
        }
        logger.info((Object)("Mule Component " + name + " has been paused successfully"));
    }

    public void resumeComponent(String name) throws UMOException {
        UMOComponent component = (UMOComponent)this.components.get((Object)name);
        if (component == null) {
            throw new MuleException("Cannot find Mule Component " + name);
        }
        try {
            component.resume();
        }
        catch (Exception e) {
            throw new MuleException("Failed to stop Mule session: " + name, e);
        }
        logger.info((Object)("Mule Component " + name + " has been resumed successfully"));
    }

    public void setComponents(List descriptors) throws UMOException {
        Iterator iterator = descriptors.iterator();
        while (iterator.hasNext()) {
            this.registerComponent((UMODescriptor)iterator.next());
        }
    }

    public void initialise() throws InitialisationException {
        if (!this.initialised.get()) {
            this.fireEvent(new ModelEvent(this, 201));
            UMOComponent temp = null;
            Iterator i = this.components.values().iterator();
            while (i.hasNext()) {
                temp = (UMOComponent)i.next();
                temp.initialise();
                logger.info((Object)("Component " + temp.getDescriptor().getName() + " has been started successfully"));
            }
            this.initialised.set(true);
            this.fireEvent(new ModelEvent(this, 202));
        } else {
            logger.debug((Object)"Model already initialised");
        }
    }

    public UMOExceptionStrategy getExceptionStrategy() {
        return this.exceptionStrategy;
    }

    public void setExceptionStrategy(UMOExceptionStrategy exceptionStrategy) {
        this.exceptionStrategy = exceptionStrategy;
    }

    public UMODescriptor getDescriptor(String name) {
        return (UMODescriptor)this.descriptors.get((Object)name);
    }

    public Iterator getComponentNames() {
        return this.components.keySet().iterator();
    }

    public void setListeners(ServerEventManager listeners) {
        this.listeners = listeners;
    }

    void fireEvent(UMOServerEvent event) {
        if (this.listeners != null) {
            this.listeners.fireEvent(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

