/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.impl.ImmutableMuleDescriptor;
import org.mule.impl.InterceptorsInvoker;
import org.mule.impl.MuleComponent;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleEvent;
import org.mule.impl.RequestContext;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.interceptors.LifecycleInterceptor;
import org.mule.management.stats.ComponentStatistics;
import org.mule.providers.AbstractConnector;
import org.mule.providers.ReplyToHandler;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOImmutableDescriptor;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Lifecycle;
import org.mule.umo.lifecycle.UMOLifecycleAdapter;
import org.mule.umo.model.ModelException;
import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.util.ObjectPool;

public class MuleProxy
implements Runnable,
Lifecycle {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$MuleProxy == null ? (class$org$mule$impl$MuleProxy = MuleProxy.class$("org.mule.impl.MuleProxy")) : class$org$mule$impl$MuleProxy));
    private MuleEvent event;
    private UMOLifecycleAdapter umo;
    private ImmutableMuleDescriptor descriptor;
    private boolean suspended = true;
    private List interceptorList;
    private ObjectPool proxyPool;
    private Object lock = new Object();
    private ComponentStatistics stat = null;
    static /* synthetic */ Class class$org$mule$impl$MuleProxy;

    public MuleProxy(Object component, MuleDescriptor descriptor, ObjectPool proxyPool) throws UMOException {
        this.descriptor = new ImmutableMuleDescriptor(descriptor);
        this.proxyPool = proxyPool;
        UMOModel model = MuleManager.getInstance().getModel();
        UMOEntryPointResolver resolver = model.getEntryPointResolver();
        this.umo = model.getLifecycleAdapterFactory().create(component, descriptor, resolver);
        this.interceptorList = descriptor.getInterceptors().size() == 0 ? new CopyOnWriteArrayList() : descriptor.getInterceptors();
        Iterator iter = this.interceptorList.iterator();
        while (iter.hasNext()) {
            Object temp = iter.next();
            if (!(temp instanceof LifecycleInterceptor)) continue;
            try {
                ((LifecycleInterceptor)temp).initialise();
            }
            catch (Exception e) {
                throw new ModelException("Failed to initialise interceptor on component: " + e.getMessage(), e);
            }
        }
        this.interceptorList.add(this.interceptorList.size(), this.umo);
        try {
            this.umo.initialise();
        }
        catch (Exception e) {
            throw new ModelException("Failed to initialise component: " + e.getMessage(), e);
        }
    }

    public void start() throws UMOException {
        this.checkDisposed();
        if (!this.umo.isStarted()) {
            try {
                this.umo.start();
            }
            catch (Exception e) {
                throw new ModelException("Failed to start component: " + e.getMessage(), e);
            }
        }
    }

    public boolean isStarted() {
        return this.umo.isStarted();
    }

    public void stop() throws UMOException {
        this.checkDisposed();
        if (this.umo.isStarted()) {
            try {
                this.umo.stop();
            }
            catch (Exception e) {
                throw new ModelException("Failed to stop component: " + e.getMessage(), e);
            }
        }
    }

    public void dispose() throws UMOException {
        this.checkDisposed();
        Iterator iter = this.interceptorList.iterator();
        while (iter.hasNext()) {
            Object temp = iter.next();
            if (!(temp instanceof LifecycleInterceptor)) continue;
            try {
                ((LifecycleInterceptor)temp).dispose();
            }
            catch (Exception e) {
                throw new MuleException("Failed to dispose Mule proxy: " + this.descriptor.getName(), e);
            }
        }
        try {
            this.umo.dispose();
        }
        catch (Exception e) {
            throw new ModelException("Failed to dispose component: " + e.getMessage(), e);
        }
    }

    private void checkDisposed() {
        if (this.umo.isDisposed()) {
            throw new IllegalStateException("Components Disposed Of");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(UMOEvent event) {
        Object object = this.lock;
        synchronized (object) {
            this.event = (MuleEvent)event;
        }
    }

    public ComponentStatistics getStatistics() {
        return this.stat;
    }

    public void setStatistics(ComponentStatistics stat) {
        this.stat = stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object onCall(UMOEvent event) throws UMOException {
        logger.trace((Object)("MuleProxy: sync call for Mule UMO " + this.descriptor.getName()));
        UMOMessage returnMessage = null;
        try {
            if (event.getEndpoint().canReceive()) {
                RequestContext.setEvent(event);
                Object replyTo = event.getMessage().getReplyTo();
                InterceptorsInvoker invoker = new InterceptorsInvoker(this.interceptorList, this.descriptor, event.getMessage());
                long startTime = 0L;
                if (this.stat.isEnabled()) {
                    startTime = System.currentTimeMillis();
                }
                UMOMessage result = invoker.execute();
                if (this.stat.isEnabled()) {
                    this.stat.addExecutionTime(System.currentTimeMillis() - startTime);
                }
                event = RequestContext.getEvent();
                if (result != null && !event.isStopFurtherProcessing()) {
                    Map context = RequestContext.clearProperties();
                    if (context != null) {
                        result.addProperties(context);
                    }
                    returnMessage = this.descriptor.getOutboundRouter().route(result, event.getSession(), event.isSynchronous());
                } else {
                    returnMessage = result;
                }
                if (result != null && replyTo != null) {
                    String requestor = (String)result.getProperty("MULE_REPLYTO_REQUESTOR");
                    ReplyToHandler replyToHandler = ((AbstractConnector)event.getEndpoint().getConnector()).getReplyToHandler();
                    if (replyToHandler != null && (requestor != null && !requestor.equals(this.descriptor.getName()) || requestor == null)) {
                        replyToHandler.processReplyTo(event, result, replyTo);
                    }
                }
            } else {
                returnMessage = event.getSession().sendEvent(event);
                this.processReplyTo(returnMessage);
            }
            if (this.stat.isEnabled()) {
                this.stat.incSentEventSync();
            }
        }
        catch (Exception e) {
            event.getSession().setValid(false);
            this.handleException(event, e);
        }
        finally {
            ((MuleComponent)event.getComponent()).finaliseEvent(event);
        }
        return returnMessage;
    }

    public void handleException(Object source, Throwable exception) {
        this.descriptor.getExceptionStrategy().handleException(source, exception);
    }

    public String toString() {
        return "proxy for: " + this.descriptor.toString();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    private void processReplyTo(UMOMessage returnMessage) throws UMOException {
        if (returnMessage != null && returnMessage.getReplyTo() != null) {
            logger.info((Object)("sending reply to: " + returnMessage.getReplyTo()));
            MuleEndpointURI endpointUri = new MuleEndpointURI(returnMessage.getReplyTo().toString());
            UMOEndpoint endpoint = MuleEndpoint.getOrCreateEndpointForUri(endpointUri, "sender");
            MuleEvent replyToEvent = new MuleEvent(returnMessage, endpoint, this.event.getSession(), false);
            replyToEvent.removeProperty("MULE_REPLYTO");
            this.onEvent(replyToEvent);
            logger.info((Object)("reply to sent: " + returnMessage.getReplyTo()));
            if (this.stat.isEnabled()) {
                this.stat.incSentReplyToEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block16: {
            block15: {
                logger.trace((Object)("MuleProxy: async onEvent for Mule UMO " + this.descriptor.getName()));
                if (this.event.getEndpoint().canReceive()) {
                    RequestContext.setEvent(this.event);
                    Object replyTo = this.event.getMessage().getReplyTo();
                    ReplyToHandler replyToHandler = ((AbstractConnector)this.event.getEndpoint().getConnector()).getReplyToHandler();
                    InterceptorsInvoker invoker = new InterceptorsInvoker(this.interceptorList, this.descriptor, this.event.getMessage());
                    long startTime = 0L;
                    if (this.stat.isEnabled()) {
                        startTime = System.currentTimeMillis();
                    }
                    UMOMessage result = invoker.execute();
                    if (this.stat.isEnabled()) {
                        this.stat.addExecutionTime(System.currentTimeMillis() - startTime);
                    }
                    this.event = (MuleEvent)RequestContext.getEvent();
                    if (result != null && !this.event.isStopFurtherProcessing()) {
                        this.descriptor.getOutboundRouter().route(result, this.event.getSession(), this.event.isSynchronous());
                    }
                    if (result != null && replyTo != null) {
                        String requestor = (String)result.getProperty("MULE_REPLYTO_REQUESTOR");
                        if (replyToHandler != null && (requestor != null && !requestor.equals(this.descriptor.getName()) || requestor == null)) {
                            replyToHandler.processReplyTo(this.event, result, replyTo);
                        }
                    }
                } else {
                    UMOMessageDispatcher dispatcher = this.event.getEndpoint().getConnector().getDispatcher(this.event.getEndpoint().getEndpointURI().getAddress());
                    dispatcher.dispatch(this.event);
                }
                ((MuleComponent)this.event.getComponent()).finaliseEvent(this.event);
                if (!this.stat.isEnabled()) break block15;
                this.stat.incSentEventASync();
            }
            Object var9_9 = null;
            try {
                this.proxyPool.returnObject(this);
            }
            catch (Exception e2) {
                logger.error((Object)("Failed to return proxy: " + e2.getMessage()), (Throwable)e2);
            }
            break block16;
            {
                catch (Exception e) {
                    ((MuleComponent)this.event.getComponent()).finaliseEvent(this.event);
                    this.event.getSession().setValid(false);
                    this.handleException(this.event, e);
                    Object var9_10 = null;
                    try {
                        this.proxyPool.returnObject(this);
                    }
                    catch (Exception e2) {
                        logger.error((Object)("Failed to return proxy: " + e2.getMessage()), (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    this.proxyPool.returnObject(this);
                }
                catch (Exception e2) {
                    logger.error((Object)("Failed to return proxy: " + e2.getMessage()), (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    public UMOImmutableDescriptor getDescriptor() {
        return this.descriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

