/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.impl.MuleEvent;
import org.mule.impl.RequestContext;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.providers.AbstractConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.EndpointNotFoundException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.routing.UMOOutboundMessageRouter;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.util.UUID;

public final class MuleSession
implements UMOSession {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$MuleSession == null ? (class$org$mule$impl$MuleSession = MuleSession.class$("org.mule.impl.MuleSession")) : class$org$mule$impl$MuleSession));
    private UMOComponent component = null;
    private boolean valid = true;
    private String id = new UUID().getUUID();
    private UMOSecurityContext securityContext;
    static /* synthetic */ Class class$org$mule$impl$MuleSession;

    public MuleSession() {
    }

    public MuleSession(UMOComponent component, UMOTransaction transaction) {
        this();
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        this.component = component;
    }

    public void dispatchEvent(UMOMessage message) throws UMOException {
        UMOOutboundMessageRouter router = this.component.getDescriptor().getOutboundRouter();
        if (router == null) {
            throw new EndpointNotFoundException("There is no outbound router configured on componennt: " + this.component.getDescriptor().getName());
        }
        router.route(message, this, false);
    }

    public void dispatchEvent(UMOMessage message, String endpointName) throws UMOException {
        this.dispatchEvent(message, MuleManager.getInstance().lookupEndpoint(endpointName));
    }

    public void dispatchEvent(UMOMessage message, UMOEndpoint endpoint) throws UMOException {
        logger.debug((Object)("Session has received asynchronous event on: " + endpoint));
        if (endpoint == null && this.component == null) {
            throw new EndpointNotFoundException("Cannot build null endpoint for session. Session component is also null");
        }
        if (endpoint == null) {
            endpoint = this.component.getDescriptor().getOutboundEndpoint();
        }
        UMOEvent event = this.createOutboundEvent(message, endpoint, RequestContext.getEvent());
        this.dispatchEvent(event);
    }

    public UMOMessage sendEvent(UMOMessage message, String endpointName) throws UMOException {
        return this.sendEvent(message, MuleManager.getInstance().lookupEndpoint(endpointName));
    }

    public UMOMessage sendEvent(UMOMessage message) throws UMOException {
        UMOOutboundMessageRouter router = this.component.getDescriptor().getOutboundRouter();
        if (router == null) {
            throw new EndpointNotFoundException("There is no outbound router configured on componennt: " + this.component.getDescriptor().getName());
        }
        return router.route(message, this, true);
    }

    public UMOMessage sendEvent(UMOMessage message, UMOEndpoint endpoint) throws UMOException {
        logger.debug((Object)("Session has received synchronous event on: " + endpoint));
        if (endpoint == null && this.component == null) {
            throw new EndpointNotFoundException("Cannot build null endpoint for session. Session component is also null");
        }
        if (endpoint == null) {
            endpoint = this.component.getDescriptor().getOutboundEndpoint();
        }
        UMOEvent event = this.createOutboundEvent(message, endpoint, RequestContext.getEvent());
        return this.sendEvent(event);
    }

    public synchronized void dispatchEvent(UMOEvent event) throws UMOException {
        if (event.getEndpoint().canSend()) {
            try {
                logger.debug((Object)("dispatching event: " + event));
                UMOMessageDispatcher dispatcher = event.getEndpoint().getConnector().getDispatcher(event.getEndpoint().getEndpointURI().getAddress());
                dispatcher.dispatch(event);
            }
            catch (Exception e) {
                throw new MuleException("Failed to send event through Connector dispatcher: " + e.getMessage(), e);
            }
        } else if (this.component != null) {
            logger.debug((Object)("dispatching event to component: " + this.component.getDescriptor().getName() + " event is: " + event));
            this.component.dispatchEvent(event);
        } else {
            throw new MuleException("Cannot dispatch event, endpoint is a receiver and there is no current compoenent");
        }
    }

    public String getId() {
        return this.id;
    }

    public UMOMessage sendEvent(UMOEvent event) throws UMOException {
        String timeout = (String)event.removeProperty("MULE_EVENT_TIMEOUT");
        if (timeout != null) {
            event.setTimeout(Integer.parseInt(timeout));
        }
        if (event.getEndpoint().canSend()) {
            try {
                logger.debug((Object)("sending event: " + event));
                UMOMessageDispatcher dispatcher = event.getEndpoint().getConnector().getDispatcher(event.getEndpoint().getEndpointURI().getAddress());
                return dispatcher.send(event);
            }
            catch (UMOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MuleException("Failed to send event through Connector dispatcher: " + e.getMessage(), e);
            }
        }
        if (this.component != null) {
            logger.debug((Object)("dispatching event to component: " + this.component.getDescriptor().getName() + " event is: " + event));
            return this.component.sendEvent(event);
        }
        throw new MuleException("Cannot send event, endpoint is a receiver and there is no current compoenent");
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean value) {
        this.valid = value;
    }

    public UMOMessage receiveEvent(String endpointName, long timeout) throws UMOException {
        UMOEndpoint endpoint = MuleEndpoint.getOrCreateEndpointForUri(endpointName, "receiver");
        return this.receiveEvent(endpoint, timeout);
    }

    public UMOMessage receiveEvent(UMOEndpoint endpoint, long timeout) throws UMOException {
        try {
            UMOMessageDispatcher dispatcher = endpoint.getConnector().getDispatcher(endpoint.getEndpointURI().getAddress());
            return dispatcher.receive(endpoint.getEndpointURI(), timeout);
        }
        catch (Exception e) {
            throw new MuleException("Failed to receive event: " + e.getMessage(), e);
        }
    }

    public UMOEvent createOutboundEvent(UMOMessage message, UMOEndpoint endpoint, UMOEvent previousEvent) throws UMOException {
        logger.debug((Object)("Creating event with data: " + message.getPayload().getClass().getName() + ", for endpoint: " + endpoint.toString()));
        if (endpoint == null) {
            throw new MuleException("When creating an event the proivder cannot be null");
        }
        if (message == null) {
            throw new MuleException("When creating an event the data and/or the properties must be set");
        }
        if (endpoint.getTransformer() == null && endpoint.getConnector() instanceof AbstractConnector) {
            endpoint.setTransformer(((AbstractConnector)endpoint.getConnector()).getDefaultOutboundTransformer());
            logger.debug((Object)("Using default connector outbound transformer: " + endpoint.getTransformer()));
        }
        try {
            MuleEvent event = previousEvent != null ? new MuleEvent(message, endpoint, this.component, previousEvent) : new MuleEvent(message, endpoint, (UMOSession)this, false, null);
            return event;
        }
        catch (Exception e) {
            throw new MuleException("Failed to create event using endpoint: " + endpoint.getConnector().getClass().getName(), e);
        }
    }

    public UMOComponent getComponent() {
        return this.component;
    }

    void setComponent(UMOComponent component) {
        this.component = component;
    }

    public void setSecurityContext(UMOSecurityContext context) {
        this.securityContext = context;
    }

    public UMOSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

