/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.admin;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.net.SocketAppender;
import org.apache.log4j.xml.DOMConfigurator;
import org.mule.InitialisationException;
import org.mule.impl.internal.admin.AbstractEventLoggerAgent;
import org.mule.umo.UMOServerEvent;
import org.mule.util.PropertiesHelper;
import org.mule.util.Utility;

public class Log4jAbstractEventLoggerAgent
extends AbstractEventLoggerAgent {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$internal$admin$Log4jAbstractEventLoggerAgent == null ? (class$org$mule$impl$internal$admin$Log4jAbstractEventLoggerAgent = Log4jAbstractEventLoggerAgent.class$("org.mule.impl.internal.admin.Log4jAbstractEventLoggerAgent")) : class$org$mule$impl$internal$admin$Log4jAbstractEventLoggerAgent));
    protected static transient Logger eventLogger;
    private String logName = (class$org$mule$impl$internal$admin$Log4jAbstractEventLoggerAgent == null ? (class$org$mule$impl$internal$admin$Log4jAbstractEventLoggerAgent = Log4jAbstractEventLoggerAgent.class$("org.mule.impl.internal.admin.Log4jAbstractEventLoggerAgent")) : class$org$mule$impl$internal$admin$Log4jAbstractEventLoggerAgent).getName();
    private String logFile = null;
    private String logConfigFile = null;
    private String chainsawHost = "localhost";
    private int chainsawPort = 4445;
    private boolean enableChainsaw = false;
    private Map levelMappings = new HashMap();
    static /* synthetic */ Class class$org$mule$impl$internal$admin$Log4jAbstractEventLoggerAgent;

    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        if (this.logFile != null && !"".equals(this.logFile)) {
            buf.append("Logging events to: ").append(this.logFile);
        }
        if (this.enableChainsaw) {
            buf.append(" Chainsaw: ").append(this.chainsawHost).append(":").append(this.chainsawPort);
        }
        if (buf.length() == 0) {
            buf.append("No logging or event forwarding is configured");
        }
        return this.getName() + ": " + buf.toString();
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public void doInitialise() throws InitialisationException {
        if (this.logConfigFile != null) {
            if (this.logConfigFile.endsWith(".xml")) {
                DOMConfigurator.configure((String)this.logConfigFile);
            } else {
                PropertyConfigurator.configure((String)this.logConfigFile);
            }
        } else {
            try {
                eventLogger = Logger.getLogger((String)this.logName);
                if (this.logFile != null) {
                    File f = new File(this.logFile);
                    if (!f.exists()) {
                        Utility.createFile(this.logFile);
                    }
                    RollingFileAppender file = new RollingFileAppender((Layout)new PatternLayout("%5p %m%n"), this.logFile, true);
                    eventLogger.addAppender((Appender)file);
                }
                if (this.enableChainsaw) {
                    SocketAppender chainsaw = new SocketAppender(this.chainsawHost, this.chainsawPort);
                    eventLogger.addAppender((Appender)chainsaw);
                }
            }
            catch (IOException e) {
                throw new InitialisationException("Failed to load Log4j info: " + e.getMessage(), e);
            }
        }
    }

    protected void logEvent(UMOServerEvent e) {
        if (eventLogger != null) {
            String level = (String)PropertiesHelper.getProperty(this.levelMappings, String.valueOf(e.getAction()), "info");
            eventLogger.log(this.getPriority(level), (Object)e);
        }
    }

    private Priority getPriority(String level) {
        if (level.equalsIgnoreCase("debug")) {
            return Priority.DEBUG;
        }
        if (level.equalsIgnoreCase("warn")) {
            return Priority.WARN;
        }
        if (level.equalsIgnoreCase("error")) {
            return Priority.ERROR;
        }
        if (level.equalsIgnoreCase("fatal")) {
            return Priority.FATAL;
        }
        return Priority.INFO;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getLogConfigFile() {
        return this.logConfigFile;
    }

    public void setLogConfigFile(String logConfigFile) {
        this.logConfigFile = logConfigFile;
    }

    public String getChainsawHost() {
        return this.chainsawHost;
    }

    public void setChainsawHost(String chainsawHost) {
        this.chainsawHost = chainsawHost;
    }

    public int getChainsawPort() {
        return this.chainsawPort;
    }

    public void setChainsawPort(int chainsawPort) {
        this.chainsawPort = chainsawPort;
    }

    public boolean isEnableChainsaw() {
        return this.enableChainsaw;
    }

    public void setEnableChainsaw(boolean enableChainsaw) {
        this.enableChainsaw = enableChainsaw;
    }

    public Map getLevelMappings() {
        return this.levelMappings;
    }

    public void setLevelMappings(Map levelMappings) {
        this.levelMappings.putAll(levelMappings);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

