/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.security;

import java.util.StringTokenizer;
import org.mule.umo.security.UMOCredentials;

public class MuleCredentials
implements UMOCredentials {
    public static final String TOKEN_DELIM = "::";
    private String username;
    private char[] password;
    private Object roles;

    public MuleCredentials(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    public MuleCredentials(String username, char[] password, Object roles) {
        this.username = username;
        this.password = password;
        this.roles = roles;
    }

    public MuleCredentials(String header) {
        StringTokenizer st = new StringTokenizer(header, TOKEN_DELIM);
        this.username = st.nextToken();
        this.password = st.nextToken().toCharArray();
        if (st.hasMoreTokens()) {
            this.roles = st.nextToken();
        }
    }

    public String getToken() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.username).append(TOKEN_DELIM);
        buf.append(this.password).append(TOKEN_DELIM);
        if (this.roles != null) {
            buf.append(this.roles);
        }
        return buf.toString();
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public Object getRoles() {
        return this.roles;
    }
}

