/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.security;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.InitialisationException;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.security.SecurityProviderNotFoundException;
import org.mule.umo.security.UMOAuthentication;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.umo.security.UMOSecurityException;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.umo.security.UMOSecurityProvider;
import org.mule.umo.security.UnknownAuthenticationTypeException;

public class MuleSecurityManager
implements UMOSecurityManager {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$security$MuleSecurityManager == null ? (class$org$mule$impl$security$MuleSecurityManager = MuleSecurityManager.class$("org.mule.impl.security.MuleSecurityManager")) : class$org$mule$impl$security$MuleSecurityManager));
    private Map providers = new ConcurrentHashMap();
    private Map cryptoStrategies = new ConcurrentHashMap();
    static /* synthetic */ Class class$org$mule$impl$security$MuleSecurityManager;

    public void initialise() throws InitialisationException {
        Iterator iterator = this.providers.values().iterator();
        while (iterator.hasNext()) {
            UMOSecurityProvider provider = (UMOSecurityProvider)iterator.next();
            provider.initialise();
        }
        iterator = this.cryptoStrategies.values().iterator();
        while (iterator.hasNext()) {
            UMOEncryptionStrategy strategy = (UMOEncryptionStrategy)iterator.next();
            strategy.initialise();
        }
    }

    public UMOAuthentication authenticate(UMOAuthentication authentication) throws UMOSecurityException {
        Iterator iter = this.providers.values().iterator();
        Class<?> toTest = authentication.getClass();
        while (iter.hasNext()) {
            UMOSecurityProvider provider = (UMOSecurityProvider)iter.next();
            if (!provider.supports(toTest)) continue;
            logger.debug((Object)("Authentication attempt using " + provider.getClass().getName()));
            UMOAuthentication result = provider.authenticate(authentication);
            if (result == null) continue;
            return result;
        }
        throw new SecurityProviderNotFoundException("No authentication provider for " + toTest.getName());
    }

    public void addProvider(UMOSecurityProvider provider) {
        if (this.getProvider(provider.getName()) != null) {
            throw new IllegalArgumentException("Provider already registered: " + provider.getName());
        }
        this.providers.put(provider.getName(), provider);
    }

    public UMOSecurityProvider getProvider(String name) {
        if (name == null) {
            throw new NullPointerException("provider Name cannot be null");
        }
        return (UMOSecurityProvider)this.providers.get(name);
    }

    public UMOSecurityProvider removeProvider(String name) {
        return (UMOSecurityProvider)this.providers.remove(name);
    }

    public List getProviders() {
        return Collections.unmodifiableList(new ArrayList(this.providers.values()));
    }

    public void setProviders(List providers) {
        Iterator iterator = providers.iterator();
        while (iterator.hasNext()) {
            UMOSecurityProvider provider = (UMOSecurityProvider)iterator.next();
            this.addProvider(provider);
        }
    }

    public UMOSecurityContext createSecurityContext(UMOAuthentication authentication) throws UnknownAuthenticationTypeException {
        Iterator iter = this.providers.values().iterator();
        Class<?> toTest = authentication.getClass();
        while (iter.hasNext()) {
            UMOSecurityProvider provider = (UMOSecurityProvider)iter.next();
            if (!provider.supports(toTest)) continue;
            return provider.createSecurityContext(authentication);
        }
        throw new UnknownAuthenticationTypeException(authentication);
    }

    public UMOEncryptionStrategy getEncryptionStrategy(String name) {
        return (UMOEncryptionStrategy)this.cryptoStrategies.get(name);
    }

    public void addEncryptionStrategy(String name, UMOEncryptionStrategy strategy) {
        this.cryptoStrategies.put(name, strategy);
    }

    public UMOEncryptionStrategy removeEncryptionStrategy(String name) {
        return (UMOEncryptionStrategy)this.cryptoStrategies.remove(name);
    }

    public void setEncryptionStrategies(Map strategies) {
        this.cryptoStrategies.putAll(strategies);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

