/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.security.filters;

import org.mule.InitialisationException;
import org.mule.MuleManager;
import org.mule.impl.security.AbstractEndpointSecurityFilter;
import org.mule.impl.security.MuleAuthentication;
import org.mule.impl.security.MuleCredentials;
import org.mule.impl.security.MuleHeaderCredentialsAccessor;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.UMOEvent;
import org.mule.umo.security.CredentialsNotSetException;
import org.mule.umo.security.UMOAuthentication;
import org.mule.umo.security.UMOSecurityContext;
import org.mule.umo.security.UMOSecurityException;
import org.mule.umo.security.UnauthorisedException;

public class MuleEncryptionEndpointSecurityFilter
extends AbstractEndpointSecurityFilter {
    private UMOEncryptionStrategy strategy;
    private String strategyName;

    public MuleEncryptionEndpointSecurityFilter() {
        this.setCredentialsAccessor(new MuleHeaderCredentialsAccessor());
    }

    protected final void authenticateInbound(UMOEvent event) throws UMOSecurityException {
        UMOAuthentication authResult;
        String userHeader = (String)this.getCredentialsAccessor().getCredentials(event);
        if (userHeader == null) {
            throw new CredentialsNotSetException(event.getSession().getSecurityContext(), event.getEndpoint(), this);
        }
        byte[] creds = null;
        creds = userHeader.startsWith("Plain ") ? userHeader.substring(6).getBytes() : this.strategy.decrypt(userHeader.getBytes());
        MuleCredentials user = new MuleCredentials(new String(creds));
        MuleAuthentication umoAuthentication = new MuleAuthentication(user);
        try {
            authResult = this.getSecurityManager().authenticate(umoAuthentication);
        }
        catch (UMOSecurityException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Authentication request for user: " + user.getUsername() + " failed: " + e.toString()));
            }
            throw new UnauthorisedException("Authentication failed for " + user.getUsername() + ": " + e.getMessage(), e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication success: " + authResult.toString()));
        }
        UMOSecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
        event.getSession().setSecurityContext(context);
    }

    protected void authenticateOutbound(UMOEvent event) throws UMOSecurityException {
        if (event.getSession().getSecurityContext() == null) {
            if (this.isAuthenticate()) {
                throw new UnauthorisedException(event.getSession().getSecurityContext(), event.getEndpoint(), this);
            }
            return;
        }
        UMOAuthentication auth = event.getSession().getSecurityContext().getAuthentication();
        if (this.isAuthenticate()) {
            auth = this.getSecurityManager().authenticate(auth);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Authentication success: " + auth.toString()));
            }
        }
        String token = auth.getCredentials().toString();
        String header = new String(this.strategy.encrypt(token.getBytes()));
        this.getCredentialsAccessor().setCredentials(event, header);
    }

    protected void doInitialise() throws InitialisationException {
        if (this.strategyName != null) {
            this.strategy = MuleManager.getInstance().getSecurityManager().getEncryptionStrategy(this.strategyName);
        }
        if (this.strategy == null) {
            throw new InitialisationException("No encryption strategy has been set on this filter");
        }
    }

    public UMOEncryptionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(UMOEncryptionStrategy strategy) {
        this.strategy = strategy;
    }

    public void setStrategyName(String name) {
        this.strategyName = name;
    }
}

