/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.beans.ExceptionListener;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.InitialisationException;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.ThreadingProfile;
import org.mule.impl.AlreadyInitialisedException;
import org.mule.impl.DefaultExceptionStrategy;
import org.mule.providers.DefaultReplyToHandler;
import org.mule.providers.ReplyToHandler;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOExceptionStrategy;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.provider.UMOMessageDispatcherFactory;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.transformer.UMOTransformer;

public abstract class AbstractConnector
implements UMOConnector,
ExceptionListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    public static final long DEFAULT_RETRY_FREQUENCY = 1000L;
    public static final int DEFAULT_RETRY_COUNT = 3;
    protected SynchronizedBoolean started = new SynchronizedBoolean(false);
    protected SynchronizedBoolean initialised = new SynchronizedBoolean(false);
    protected String name = null;
    protected UMOExceptionStrategy exceptionStrategy = null;
    protected SynchronizedBoolean disposed = new SynchronizedBoolean(false);
    protected UMOMessageDispatcherFactory dispatcherFactory;
    protected LRUMap dispatchers;
    protected ConcurrentHashMap receivers;
    private ThreadingProfile dispatcherThreadingProfile = null;
    private ThreadingProfile receiverThreadingProfile = null;
    private int retryCount = 2;
    private long retryFrequency = 2000L;
    private boolean disposeDispatcherOnCompletion = false;
    protected UMOTransformer defaultInboundTransformer = null;
    protected UMOTransformer defaultOutboundTransformer = null;
    protected UMOTransformer defaultResponseTransformer = null;

    public AbstractConnector() {
        this.exceptionStrategy = new DefaultExceptionStrategy();
        this.dispatchers = new LRUMap(16);
        this.receivers = new ConcurrentHashMap();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("Connector name cannot be null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Set UMOConnector name to: " + newName));
        }
        this.name = newName;
    }

    public final synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            throw new AlreadyInitialisedException("Connector: " + this.getName() + " is already initialised");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Initialising " + this.getClass().getName()));
        }
        this.doInitialise();
        this.initialised.set(true);
    }

    public abstract String getProtocol();

    public long getRetryFrequency() {
        return this.retryFrequency;
    }

    public void setRetryFrequency(long retryFrequency) {
        if (retryFrequency < 1L) {
            retryFrequency = 1000L;
        }
        this.retryFrequency = retryFrequency;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        if (retryCount < 0) {
            retryCount = 3;
        }
        this.retryCount = retryCount;
    }

    public final void start() throws UMOException {
        if (this.isDisposed()) {
            throw new MuleException("Cannot start an endpoint once it has been disposing");
        }
        if (!this.started.get()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Starting Connector: " + this.getClass().getName()));
            }
            this.startConnector();
            this.started.set(true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Connector: " + this.getClass().getName() + " has been started"));
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public final void stop() throws UMOException {
        if (this.isDisposed()) {
            return;
        }
        if (this.started.get()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Stopping Connector: " + this.getClass().getName()));
            }
            this.stopConnector();
            this.started.set(false);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Connector " + this.getClass().getName() + " has been stopped"));
            }
        }
    }

    public final synchronized void dispose() throws UMOException {
        Object entry;
        this.disposed.set(true);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Disposing Connector: " + this.getClass().getName()));
            this.logger.debug((Object)"Disposing Receivers");
        }
        if (this.receivers != null) {
            Iterator iterator = this.receivers.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                try {
                    this.destroyReceiver((UMOMessageReceiver)entry.getValue(), null);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to destroy receiver: " + e.getMessage()), (Throwable)e);
                }
                this.receivers.remove(entry.getKey());
            }
            this.logger.debug((Object)"Receivers Disposed");
        }
        if (this.dispatchers != null) {
            this.logger.debug((Object)"Disposing Dispatchers");
            entry = null;
            while (this.dispatchers.size() != 0) {
                entry = this.dispatchers.remove(this.dispatchers.getFirstKey());
                if (entry == null) continue;
                ((UMOMessageDispatcher)entry).dispose();
            }
            this.logger.debug((Object)"Dispatchers Disposed");
        }
        this.disposeConnector();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Connector " + this.getClass().getName() + " has been disposed."));
        }
        this.receivers = null;
        this.dispatchers = null;
    }

    public boolean isDisposed() {
        return this.disposed.get();
    }

    public void handleException(Object message, Throwable exception) {
        if (this.exceptionStrategy == null) {
            throw new MuleRuntimeException("Exception occurred in endpoint: " + this.getName() + ". Exception handler is not set. Message is: " + message, exception);
        }
        this.exceptionStrategy.handleException(message, exception);
    }

    public void exceptionThrown(Exception e) {
        this.handleException("Dispatcher failed while processing event: " + e, e);
    }

    public UMOExceptionStrategy getExceptionStrategy() {
        return this.exceptionStrategy;
    }

    public void setExceptionStrategy(UMOExceptionStrategy strategy) {
        this.exceptionStrategy = strategy;
    }

    public UMOMessageDispatcherFactory getDispatcherFactory() {
        return this.dispatcherFactory;
    }

    public void setDispatcherFactory(UMOMessageDispatcherFactory dispatcerFactory) {
        this.dispatcherFactory = dispatcerFactory;
    }

    public synchronized UMOMessageDispatcher getDispatcher(String endpoint) throws UMOException {
        UMOMessageDispatcher dispatcher = null;
        if (endpoint == null || "".equals(endpoint)) {
            endpoint = "ANY";
        }
        if ("ANY".equals(endpoint)) {
            dispatcher = (UMOMessageDispatcher)this.dispatchers.getFirstValue();
            while (dispatcher != null && dispatcher.isDisposed()) {
                this.dispatchers.values().remove(dispatcher);
                dispatcher = (UMOMessageDispatcher)this.dispatchers.getFirstValue();
            }
        } else {
            if (this.dispatchers == null) {
                throw new NullPointerException("Dispatchers are null for connector: " + this.name);
            }
            dispatcher = (UMOMessageDispatcher)this.dispatchers.get((Object)endpoint);
            if (dispatcher != null && dispatcher.isDisposed()) {
                this.dispatchers.values().remove(dispatcher);
                dispatcher = null;
            }
        }
        if (dispatcher == null) {
            dispatcher = this.createDispatcher();
            this.dispatchers.put((Object)endpoint, (Object)dispatcher);
        }
        return dispatcher;
    }

    protected UMOMessageDispatcher createDispatcher() throws UMOException {
        if (this.dispatcherFactory == null) {
            throw new InitialisationException("Connector: " + this.name + " has not been started. Cannot create dispatcher");
        }
        UMOMessageDispatcher dispatcher = this.dispatcherFactory.create(this);
        return dispatcher;
    }

    public UMOMessageReceiver registerListener(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        if (endpoint == null || component == null) {
            throw new IllegalArgumentException("The endpoint and component cannot be null when registering a listener");
        }
        UMOEndpointURI endpointUri = endpoint.getEndpointURI();
        if (endpointUri == null) {
            throw new MuleException("Endpoint cannot be null when registering a listener");
        }
        this.logger.info((Object)("registering listener: " + component.getDescriptor().getName() + " on endpointUri: " + endpointUri.toString()));
        UMOMessageReceiver receiver = (UMOMessageReceiver)this.receivers.get(this.getReceiverKey(component, endpoint));
        if (receiver != null) {
            throw new MuleException("There is already a listener registered on this connector on endpointUri: " + endpointUri);
        }
        receiver = this.createReceiver(component, endpoint);
        this.receivers.put(this.getReceiverKey(component, endpoint), (Object)receiver);
        return receiver;
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        if (endpoint.getEndpointURI().getFilterAddress() != null) {
            return endpoint.getEndpointURI().getFilterAddress();
        }
        return endpoint.getEndpointURI().getAddress();
    }

    public final void unregisterListener(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        UMOMessageReceiver receiver;
        if (endpoint == null || component == null || endpoint.getEndpointURI() == null) {
            throw new IllegalArgumentException("The endpoint and component and endpointUri cannot be null when you unregister a listener");
        }
        UMOEndpointURI endpointUri = endpoint.getEndpointURI();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("removing listener on endpointUri: " + endpointUri));
        }
        if ((receiver = (UMOMessageReceiver)this.receivers.remove(this.getReceiverKey(component, endpoint))) != null) {
            this.destroyReceiver(receiver, endpoint);
            receiver.dispose();
        }
    }

    public ThreadingProfile getDispatcherThreadingProfile() {
        if (this.dispatcherThreadingProfile == null) {
            this.dispatcherThreadingProfile = MuleManager.getConfiguration().getMessageReceiverThreadingProfile();
        }
        return this.dispatcherThreadingProfile;
    }

    public void setDispatcherThreadingProfile(ThreadingProfile dispatcherThreadingProfile) {
        this.dispatcherThreadingProfile = dispatcherThreadingProfile;
    }

    public ThreadingProfile getReceiverThreadingProfile() {
        if (this.receiverThreadingProfile == null) {
            this.receiverThreadingProfile = MuleManager.getConfiguration().getMessageReceiverThreadingProfile();
        }
        return this.receiverThreadingProfile;
    }

    public void setReceiverThreadingProfile(ThreadingProfile receiverThreadingProfile) {
        this.receiverThreadingProfile = receiverThreadingProfile;
    }

    public abstract UMOMessageReceiver createReceiver(UMOComponent var1, UMOEndpoint var2) throws Exception;

    public void destroyReceiver(UMOMessageReceiver receiver, UMOEndpoint endpoint) throws Exception {
        receiver.dispose();
    }

    protected void startConnector() throws UMOException {
    }

    protected void stopConnector() throws UMOException {
    }

    public boolean isDisposeDispatcherOnCompletion() {
        return this.disposeDispatcherOnCompletion;
    }

    public void setDisposeDispatcherOnCompletion(boolean disposeDispatcherOnCompletion) {
        this.disposeDispatcherOnCompletion = disposeDispatcherOnCompletion;
    }

    protected void disposeConnector() throws UMOException {
    }

    public void doInitialise() throws InitialisationException {
    }

    public UMOTransformer getDefaultInboundTransformer() {
        if (this.defaultInboundTransformer != null) {
            try {
                return (UMOTransformer)this.defaultInboundTransformer.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Failed to clone default Inbound transformer");
                return null;
            }
        }
        return null;
    }

    public void setDefaultInboundTransformer(UMOTransformer defaultInboundTransformer) {
        this.defaultInboundTransformer = defaultInboundTransformer;
    }

    public UMOTransformer getDefaultResponseTransformer() {
        if (this.defaultResponseTransformer != null) {
            try {
                return (UMOTransformer)this.defaultResponseTransformer.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Failed to clone default Outbound transformer");
                return null;
            }
        }
        return null;
    }

    public UMOTransformer getDefaultOutboundTransformer() {
        if (this.defaultOutboundTransformer != null) {
            try {
                return (UMOTransformer)this.defaultOutboundTransformer.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)"Failed to clone default Outbound transformer");
                return null;
            }
        }
        return null;
    }

    public void setDefaultOutboundTransformer(UMOTransformer defaultOutboundTransformer) {
        this.defaultOutboundTransformer = defaultOutboundTransformer;
    }

    public void setDefaultResponseTransformer(UMOTransformer defaultResponseTransformer) {
        this.defaultResponseTransformer = defaultResponseTransformer;
    }

    public ReplyToHandler getReplyToHandler() {
        return new DefaultReplyToHandler(this.defaultResponseTransformer);
    }
}

