/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.beans.ExceptionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.ThreadingProfile;
import org.mule.impl.RequestContext;
import org.mule.providers.AbstractConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageDispatcher;

public abstract class AbstractMessageDispatcher
implements UMOMessageDispatcher,
ExceptionListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected PooledExecutor threadPool = null;
    protected boolean disposeOnCompletion = false;
    protected AbstractConnector connector;
    protected boolean disposed = false;
    protected boolean doThreading = true;

    public AbstractMessageDispatcher(AbstractConnector connector) {
        this.init(connector);
        this.disposeOnCompletion = connector.isDisposeDispatcherOnCompletion();
    }

    private void init(AbstractConnector connector) {
        this.connector = connector;
        if (connector instanceof AbstractConnector) {
            ThreadingProfile profile = connector.getDispatcherThreadingProfile();
            this.threadPool = profile.createPool(connector.getName());
            this.doThreading = profile.isDoThreading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispatch(UMOEvent event) throws Exception {
        block7: {
            try {
                event.setSynchronous(false);
                event.setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
                RequestContext.setEvent(event);
                if (this.doThreading && !event.isSynchronous()) {
                    this.threadPool.execute((Runnable)new Worker(event));
                    break block7;
                }
                try {
                    this.doDispatch(event);
                }
                finally {
                    if (this.disposeOnCompletion) {
                        this.dispose();
                    }
                }
            }
            catch (Exception e) {
                this.logger.info((Object)"Exception occurred while executing on this dispatcher. disposing before continuing");
                this.dispose();
                throw e;
            }
        }
    }

    public final UMOMessage send(UMOEvent event) throws Exception {
        try {
            UMOMessage result;
            event.setSynchronous(true);
            event.setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
            RequestContext.setEvent(event);
            UMOMessage uMOMessage = result = this.doSend(event);
            return uMOMessage;
        }
        catch (Exception e) {
            this.logger.info((Object)"Exception occurred while executing on this dispatcher. disposing before continuing");
            this.dispose();
            throw e;
        }
        finally {
            if (this.disposeOnCompletion) {
                this.dispose();
            }
        }
    }

    public void exceptionThrown(Exception e) {
        this.getConnector().handleException("Exception caught in ThreadPool: " + e.getMessage(), e);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() throws UMOException {
        if (!this.disposed) {
            try {
                this.doDispose();
                Object var2_1 = null;
                this.connector.dispatchers.values().remove(this);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.connector.dispatchers.values().remove(this);
                this.disposed = true;
                throw throwable;
            }
            this.disposed = true;
            {
            }
        }
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public abstract void doDispose() throws UMOException;

    public abstract void doDispatch(UMOEvent var1) throws Exception;

    public abstract UMOMessage doSend(UMOEvent var1) throws Exception;

    private class Worker
    implements Runnable {
        private UMOEvent event;

        public Worker(UMOEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            RequestContext.setEvent(this.event);
            AbstractMessageDispatcher.this.doDispatch(this.event);
            Object var4_1 = null;
            if (!AbstractMessageDispatcher.this.disposeOnCompletion) return;
            try {
                AbstractMessageDispatcher.this.dispose();
                return;
            }
            catch (UMOException e2) {
                AbstractMessageDispatcher.this.logger.error((Object)("Failed to dispose dispatcher: " + e2), (Throwable)e2);
            }
            return;
            {
                catch (Exception e) {
                    try {
                        AbstractMessageDispatcher.this.dispose();
                    }
                    catch (UMOException uMOException) {
                        // empty catch block
                    }
                    AbstractMessageDispatcher.this.getConnector().handleException("Failed to intercept doDispatch: " + e.getMessage(), e);
                    Object var4_2 = null;
                    if (!AbstractMessageDispatcher.this.disposeOnCompletion) return;
                    try {
                        AbstractMessageDispatcher.this.dispose();
                        return;
                    }
                    catch (UMOException e2) {
                        AbstractMessageDispatcher.this.logger.error((Object)("Failed to dispose dispatcher: " + e2), (Throwable)e2);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (!AbstractMessageDispatcher.this.disposeOnCompletion) throw throwable;
                try {
                    AbstractMessageDispatcher.this.dispose();
                    throw throwable;
                }
                catch (UMOException e2) {
                    AbstractMessageDispatcher.this.logger.error((Object)("Failed to dispose dispatcher: " + e2), (Throwable)e2);
                }
                throw throwable;
            }
        }
    }
}

