/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.InitialisationException;
import org.mule.MuleManager;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.RequestContext;
import org.mule.impl.ResponseOutputStream;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.umo.provider.UniqueIdNotSupportedException;
import org.mule.umo.security.UMOSecurityException;

public abstract class AbstractMessageReceiver
implements UMOMessageReceiver {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMOComponent component = null;
    protected UMOEndpoint endpoint = null;
    protected UMOModel model = null;
    protected UMOConnector connector = null;
    protected boolean serverSide = true;
    protected SynchronizedBoolean disposing = new SynchronizedBoolean(false);
    private UMOEndpointURI endpointUri;

    public synchronized void create(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        this.setConnector(connector);
        this.setComponent(component);
        this.setEndpoint(endpoint);
        this.endpointUri = endpoint.getEndpointURI();
        this.model = MuleManager.getInstance().getModel();
    }

    public UMOEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void handleException(Object message, Throwable exception) {
        this.connector.getExceptionStrategy().handleException(message, exception);
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public void setConnector(UMOConnector connector) {
        if (connector == null) {
            throw new IllegalArgumentException("Connector cannot be null");
        }
        this.connector = connector;
    }

    public UMOComponent getComponent() {
        return this.component;
    }

    public final UMOMessage routeMessage(UMOMessage message) throws UMOException {
        return this.routeMessage(message, this.endpoint.isSynchronous());
    }

    public final UMOMessage routeMessage(UMOMessage message, boolean synchronous) throws UMOException {
        UMOTransaction tx;
        return this.routeMessage(message, tx, (tx = TransactionCoordination.getInstance().getTransaction()) != null || synchronous, null);
    }

    public final UMOMessage routeMessage(UMOMessage message, UMOTransaction trans, boolean synchronous) throws UMOException {
        return this.routeMessage(message, trans, synchronous, null);
    }

    public final UMOMessage routeMessage(UMOMessage message, OutputStream outputStream) throws UMOException {
        return this.routeMessage(message, this.endpoint.isSynchronous(), outputStream);
    }

    public final UMOMessage routeMessage(UMOMessage message, boolean synchronous, OutputStream outputStream) throws UMOException {
        UMOTransaction tx;
        return this.routeMessage(message, tx, (tx = TransactionCoordination.getInstance().getTransaction()) != null || synchronous, outputStream);
    }

    public final UMOMessage routeMessage(UMOMessage message, UMOTransaction trans, boolean synchronous, OutputStream outputStream) throws UMOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Received message from: " + this.endpoint.getEndpointURI()));
            this.logger.debug((Object)("Payload is of type: " + message.getPayload().getClass().getName()));
            StringBuffer buf = new StringBuffer();
            Map props = message.getProperties();
            Iterator iterator = props.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                buf.append("  ").append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
            }
            this.logger.debug((Object)("Message properties:\n" + buf.toString()));
        }
        ResponseOutputStream ros = null;
        if (outputStream != null) {
            ros = outputStream instanceof ResponseOutputStream ? (ResponseOutputStream)outputStream : new ResponseOutputStream(outputStream);
        }
        if (this.endpoint.getFilter() != null && !this.endpoint.getFilter().accept(message)) {
            this.handleUnacceptedFilter(message);
            return null;
        }
        MuleSession session = new MuleSession(this.component, trans);
        MuleEvent muleEvent = new MuleEvent(message, this.endpoint, (UMOSession)session, synchronous, ros);
        RequestContext.setEvent(muleEvent);
        if (this.endpoint.getSecurityFilter() != null) {
            try {
                this.endpoint.getSecurityFilter().authenticate(muleEvent);
            }
            catch (UMOSecurityException e) {
                this.logger.warn((Object)("Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                return this.handleSecurtyException(e, muleEvent);
            }
        }
        UMOMessage resultMessage = null;
        if ("response".equals(this.endpoint.getType())) {
            this.component.getDescriptor().getResponseRouter().route(muleEvent);
            return null;
        }
        resultMessage = this.component.getDescriptor().getInboundRouter().route(muleEvent);
        return resultMessage;
    }

    protected UMOMessage handleSecurtyException(UMOSecurityException e, UMOEvent event) {
        MuleMessage m = new MuleMessage(e.getMessage(), event.getProperties());
        m.setErrorCode(100);
        return m;
    }

    protected UMOMessage handleUnacceptedFilter(UMOMessage message) {
        String messageId = null;
        try {
            messageId = message.getUniqueId();
        }
        catch (UniqueIdNotSupportedException e) {
            messageId = "'no unique id'";
        }
        this.logger.warn((Object)("Message " + messageId + " failed to pass filter on endpoint: " + this.endpoint + ". Message is being ignored"));
        return null;
    }

    public void setEndpoint(UMOEndpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Provider cannot be null");
        }
        if (endpoint.getFilter() != null && !this.allowFilter(endpoint.getFilter())) {
            throw new UnsupportedOperationException("Message filter: " + endpoint.getFilter().getClass().getName() + " is not supported by this connector: " + this.connector.getClass().getName());
        }
        this.endpoint = endpoint;
    }

    public void setComponent(UMOComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        this.component = component;
    }

    public final void dispose() throws UMOException {
        this.disposing.set(true);
        this.doDispose();
    }

    protected void doDispose() throws UMOException {
    }

    public UMOEndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    boolean acceptMessage(Object message) {
        if (this.endpoint.getFilter() != null) {
            return this.endpoint.getFilter().accept(message);
        }
        return true;
    }

    protected boolean allowFilter(UMOFilter filter) throws UnsupportedOperationException {
        return true;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }
}

