/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import org.mule.InitialisationException;
import org.mule.providers.AbstractConnector;
import org.mule.providers.service.ConnectorFactory;
import org.mule.providers.service.ConnectorServiceDescriptor;
import org.mule.providers.service.ConnectorServiceException;
import org.mule.umo.MessageException;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.BeanUtils;

public abstract class AbstractServiceEnabledConnector
extends AbstractConnector {
    protected ConnectorServiceDescriptor serviceDescriptor;
    protected Properties serviceOverrides;

    public void doInitialise() throws InitialisationException {
        this.initFromServiceDescriptor();
    }

    public void initialiseFromUrl(UMOEndpointURI endpointUri) throws InitialisationException {
        if (!this.getProtocol().equalsIgnoreCase(endpointUri.getScheme()) && !this.getProtocol().equalsIgnoreCase(endpointUri.getSchemeMetaInfo())) {
            throw new InitialisationException("The endpointUri scheme is not compatible with this connector: " + this.getProtocol() + ", " + endpointUri);
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)endpointUri.getParams());
        if (endpointUri.getUserInfo() != null) {
            int i = endpointUri.getUserInfo().indexOf(":");
            if (i == -1) {
                props.setProperty("username", endpointUri.getUserInfo());
            } else {
                props.setProperty("username", endpointUri.getUserInfo().substring(0, i));
                props.setProperty("password", endpointUri.getUserInfo().substring(i + 1));
            }
        }
        if (endpointUri.getHost() != null) {
            props.setProperty("hostname", endpointUri.getHost());
            props.setProperty("host", endpointUri.getHost());
        }
        if (endpointUri.getPort() > -1) {
            props.setProperty("port", String.valueOf(endpointUri.getPort()));
        }
        try {
            BeanUtils.populateWithoutFail(this, props, true);
        }
        catch (InvocationTargetException e) {
            throw new InitialisationException(e.getMessage(), e);
        }
    }

    protected synchronized void initFromServiceDescriptor() throws InitialisationException {
        try {
            this.serviceDescriptor = ConnectorFactory.getServiceDescriptor(this.getProtocol().toLowerCase(), this.serviceOverrides);
            if (this.serviceDescriptor.getDispatcherFactory() != null) {
                this.logger.info((Object)("Loading DispatcherFactory: " + this.serviceDescriptor.getDispatcherFactory()));
                this.dispatcherFactory = this.serviceDescriptor.createDispatcherFactory();
            }
            this.defaultInboundTransformer = this.serviceDescriptor.createInboundTransformer();
            this.defaultOutboundTransformer = this.serviceDescriptor.createOutboundTransformer();
            this.defaultResponseTransformer = this.serviceDescriptor.createResponseTransformer();
        }
        catch (Exception e) {
            throw new InitialisationException("Failed to initialise connector from endpoint service descriptor: " + e.getMessage(), e);
        }
    }

    protected ConnectorServiceDescriptor getServiceDescriptor() {
        if (this.serviceDescriptor == null) {
            throw new IllegalStateException("This connector has not yet been initiaiised: " + this.name);
        }
        return this.serviceDescriptor;
    }

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        return this.getServiceDescriptor().createMessageReceiver(this, component, endpoint);
    }

    public UMOMessageAdapter getMessageAdapter(Object message) throws MessageException {
        try {
            return this.serviceDescriptor.createMessageAdapter(message);
        }
        catch (ConnectorServiceException e) {
            throw new MessageException("Failed to create message adapter from service: " + e.getMessage(), e);
        }
    }

    public Map getServiceOverrides() {
        return this.serviceOverrides;
    }

    public void setServiceOverrides(Map serviceOverrides) {
        this.serviceOverrides = new Properties();
        this.serviceOverrides.putAll((Map<?, ?>)serviceOverrides);
    }
}

