/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import org.mule.InitialisationException;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.UMOConnector;

public abstract class PollingMessageReceiver
extends AbstractMessageReceiver
implements Runnable {
    public static final long DEFAULT_POLL_FREQUENCY = 1000L;
    public static final long STARTUP_DELAY = 1000L;
    private long frequency = 1000L;
    private Thread thread;

    public PollingMessageReceiver() {
    }

    public PollingMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, Long frequency) throws InitialisationException {
        this.create(connector, component, endpoint);
        this.frequency = frequency;
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
    }

    public void run() {
        block6: {
            try {
                Thread.sleep(1000L);
                while (!this.connector.isDisposed() && !this.disposing.get()) {
                    if (this.connector.isStarted()) {
                        this.poll();
                    }
                    Thread.sleep(this.frequency);
                }
            }
            catch (Exception e) {
                if (this.disposing.get()) break block6;
                this.logger.error((Object)"An error occurred when polling", (Throwable)e);
                try {
                    this.connector.stop();
                }
                catch (Exception e2) {
                    this.logger.error((Object)("Failed to stop endpoint: " + e2.getMessage()), (Throwable)e2);
                }
            }
        }
    }

    public void setFrequency(long l) {
        this.frequency = l <= 0L ? 1000L : l;
    }

    public long getFrequency() {
        return this.frequency;
    }

    protected void doDispose() throws UMOException {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public abstract void poll() throws Exception;
}

