/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.service.ConnectorFactoryException;
import org.mule.providers.service.ConnectorServiceDescriptor;
import org.mule.providers.service.ConnectorServiceException;
import org.mule.providers.service.ConnectorServiceFinder;
import org.mule.providers.service.ConnectorServiceNotFoundException;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassHelper;
import org.mule.util.MuleObjectHelper;
import org.mule.util.ObjectFactory;
import org.mule.util.SpiHelper;

public class ConnectorFactory {
    public static final String PROVIDER_SERVICES_PATH = "org/mule/providers";
    public static final int GET_OR_CREATE_CONNECTOR = 0;
    public static final int ALWAYS_CREATE_CONNECTOR = 1;
    public static final int NEVER_CREATE_CONNECTOR = 2;
    public static final int USE_CONNECTOR = 3;
    private static Map csdCache = new HashMap();
    static /* synthetic */ Class class$org$mule$providers$service$ConnectorFactory;

    public static UMOEndpoint createEndpoint(UMOEndpointURI uri, String type) throws EndpointException {
        String scheme = uri.getSchemeMetaInfo();
        UMOConnector connector = null;
        try {
            if (uri.getCreateConnector() == 1) {
                connector = ConnectorFactory.createConnector(uri);
                MuleManager.getInstance().registerConnector(connector);
            } else if (uri.getCreateConnector() == 2) {
                connector = MuleObjectHelper.getConnectorByProtocol(scheme);
            } else if (uri.getConnectorName() != null) {
                connector = MuleManager.getInstance().lookupConnector(uri.getConnectorName());
                if (connector == null) {
                    throw new ConnectorFactoryException("No connector found called: " + uri.getConnectorName());
                }
            } else {
                connector = MuleObjectHelper.getConnectorByProtocol(scheme);
                if (connector == null) {
                    connector = ConnectorFactory.createConnector(uri);
                    MuleManager.getInstance().registerConnector(connector);
                }
            }
        }
        catch (Exception e) {
            throw new ConnectorFactoryException("Failed to get connector: " + e.getMessage(), e);
        }
        if (connector == null) {
            throw new ConnectorFactoryException("Failed to find/create connector for protocol: " + scheme);
        }
        MuleEndpoint endpoint = new MuleEndpoint();
        endpoint.setConnector(connector);
        endpoint.setEndpointURI(uri);
        String name = uri.getEndpointName();
        if (name == null) {
            name = "_" + scheme + "Endpoint#" + ((Object)endpoint).hashCode();
        }
        endpoint.setName(name);
        if (type != null) {
            endpoint.setType(type);
            UMOTransformer trans = ConnectorFactory.getTransformer(uri, connector, "receiver".equals(type));
            endpoint.setTransformer(trans);
        }
        return endpoint;
    }

    private static UMOTransformer getTransformer(UMOEndpointURI url, UMOConnector cnn, boolean inbound) throws ConnectorFactoryException {
        UMOTransformer trans = null;
        if (url.getTransformers() != null) {
            try {
                trans = MuleObjectHelper.getTransformer(url.getTransformers(), ",");
            }
            catch (MuleException e) {
                throw new ConnectorFactoryException("Failed to load transformers for endpoint: " + e.getMessage(), e);
            }
        } else {
            Map so;
            Properties overrides = new Properties();
            if (cnn instanceof AbstractServiceEnabledConnector && (so = ((AbstractServiceEnabledConnector)cnn).getServiceOverrides()) != null) {
                overrides.putAll((Map<?, ?>)so);
            }
            String scheme = url.getSchemeMetaInfo();
            ConnectorServiceDescriptor csd = ConnectorFactory.getServiceDescriptor(scheme, overrides);
            trans = inbound ? csd.createInboundTransformer() : csd.createOutboundTransformer();
        }
        return trans;
    }

    public static UMOConnector createConnector(UMOEndpointURI url) throws ConnectorFactoryException {
        UMOConnector connector;
        String scheme;
        block8: {
            scheme = url.getSchemeMetaInfo();
            connector = null;
            ConnectorServiceDescriptor psd = ConnectorFactory.getServiceDescriptor(scheme);
            if (psd.getServiceError() != null) {
                throw new ConnectorServiceException(psd.getServiceError());
            }
            try {
                if (psd.getConnectorFactory() != null) {
                    ObjectFactory factory = (ObjectFactory)ClassHelper.loadClass(psd.getConnectorFactory(), class$org$mule$providers$service$ConnectorFactory == null ? (class$org$mule$providers$service$ConnectorFactory = ConnectorFactory.class$("org.mule.providers.service.ConnectorFactory")) : class$org$mule$providers$service$ConnectorFactory).newInstance();
                    connector = (UMOConnector)factory.create();
                    break block8;
                }
                if (psd.getConnector() != null) {
                    connector = (UMOConnector)ClassHelper.loadClass(psd.getConnector(), class$org$mule$providers$service$ConnectorFactory == null ? (class$org$mule$providers$service$ConnectorFactory = ConnectorFactory.class$("org.mule.providers.service.ConnectorFactory")) : class$org$mule$providers$service$ConnectorFactory).newInstance();
                    if (connector instanceof AbstractServiceEnabledConnector) {
                        ((AbstractServiceEnabledConnector)connector).initialiseFromUrl(url);
                    }
                    break block8;
                }
                throw new ConnectorFactoryException("connector property not set for endpoint service factory: " + scheme);
            }
            catch (ConnectorFactoryException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConnectorFactoryException("failed to create endpoint with url: " + url + ". Error was: " + e.getMessage(), e);
            }
        }
        if (connector.getName() == null) {
            connector.setName("_" + scheme + "Connector#" + connector.hashCode());
        }
        return connector;
    }

    public static ConnectorServiceDescriptor getServiceDescriptor(String protocol) throws ConnectorFactoryException {
        return ConnectorFactory.getServiceDescriptor(protocol, null);
    }

    public static ConnectorServiceDescriptor getServiceDescriptor(String protocol, Properties overrides) throws ConnectorFactoryException {
        ConnectorServiceDescriptor csd = (ConnectorServiceDescriptor)csdCache.get(new CSDKey(protocol, overrides));
        if (csd == null) {
            String location = "META-INF/services/org/mule/providers";
            InputStream is = SpiHelper.findServiceDescriptor(PROVIDER_SERVICES_PATH, protocol, class$org$mule$providers$service$ConnectorFactory == null ? (class$org$mule$providers$service$ConnectorFactory = ConnectorFactory.class$("org.mule.providers.service.ConnectorFactory")) : class$org$mule$providers$service$ConnectorFactory);
            try {
                if (is != null) {
                    Properties props = new Properties();
                    props.load(is);
                    csd = new ConnectorServiceDescriptor(protocol, location, props);
                    csd.setOverrides(overrides);
                    if (csd.getServiceFinder() != null) {
                        ConnectorServiceFinder finder = csd.createServiceFinder();
                        csd = finder.findService(protocol);
                    }
                } else {
                    throw new ConnectorServiceNotFoundException("Failed to create endpoint from service location: " + location + "/" + protocol);
                }
                csdCache.put(new CSDKey(csd.getProtocol(), overrides), csd);
            }
            catch (IOException e) {
                throw new ConnectorFactoryException("Failed to create endpoint from service location: " + location + "/" + protocol + ". error is: " + e.getMessage(), e);
            }
        }
        return csd;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CSDKey {
        private Map overrides;
        private String protocol;

        public CSDKey(String protocol, Map overrides) {
            this.overrides = overrides;
            this.protocol = protocol;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CSDKey)) {
                return false;
            }
            CSDKey csdKey = (CSDKey)o;
            if (this.overrides != null ? !((Object)this.overrides).equals(csdKey.overrides) : csdKey.overrides != null) {
                return false;
            }
            return this.protocol.equals(csdKey.protocol);
        }

        public int hashCode() {
            int result = this.overrides != null ? ((Object)this.overrides).hashCode() : 0;
            result = 29 * result + this.protocol.hashCode();
            return result;
        }
    }
}

