/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.impl.MuleEvent;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.routing.RoutingException;

public class ForwardingCatchAllStrategy
extends AbstractCatchAllStrategy {
    private boolean sendTransformed = true;

    public UMOMessage catchMessage(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        if (this.getEndpoint() == null) {
            throw new RoutingException("Cannot route event in Catch all as no endpoint has been set");
        }
        try {
            UMOMessageDispatcher dispatcher = this.getEndpoint().getConnector().getDispatcher(this.getEndpoint().getEndpointURI().getAddress());
            MuleEvent newEvent = new MuleEvent(message, this.getEndpoint(), session, synchronous);
            if (synchronous) {
                UMOMessage result = dispatcher.send(newEvent);
                if (this.statistics != null) {
                    this.statistics.incrementRoutedMessage(this.getEndpoint());
                }
                return result;
            }
            dispatcher.dispatch(newEvent);
            if (this.statistics != null) {
                this.statistics.incrementRoutedMessage(this.getEndpoint());
            }
            return null;
        }
        catch (Exception e) {
            throw new RoutingException("Failed to sispatch event: " + e, e);
        }
    }

    public boolean isSendTransformed() {
        return this.sendTransformed;
    }

    public void setSendTransformed(boolean sendTransformed) {
        this.sendTransformed = sendTransformed;
    }
}

