/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.mule.MuleManager;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.umo.UMOEvent;
import org.mule.umo.provider.UniqueIdNotSupportedException;
import org.mule.umo.routing.RoutingException;
import org.mule.util.Utility;

public class IdempotentReceiver
extends SelectiveConsumer {
    private static String DEFAULT_STORE_PATH = "./idempotent";
    private Set messageIds = new HashSet();
    private File idStore;
    private String componentName;
    private boolean disablePersistence = false;
    private String storePath;

    public IdempotentReceiver() {
        DEFAULT_STORE_PATH = MuleManager.getConfiguration().getWorkingDirectoy() + "/idempotent";
        this.setStorePath(DEFAULT_STORE_PATH);
    }

    public boolean isMatch(UMOEvent event) throws RoutingException {
        if (this.idStore == null) {
            this.load(event.getComponent().getDescriptor().getName());
        }
        try {
            return !this.messageIds.contains(event.getMessage().getUniqueId());
        }
        catch (UniqueIdNotSupportedException e) {
            throw new RoutingException(e.getMessage(), e);
        }
    }

    public UMOEvent[] process(UMOEvent event) throws RoutingException {
        if (this.isMatch(event)) {
            this.checkComponentName(event.getComponent().getDescriptor().getName());
            try {
                this.storeId(event.getMessage().getUniqueId());
                return new UMOEvent[]{event};
            }
            catch (UniqueIdNotSupportedException e) {
                throw new RoutingException(e.getMessage(), e);
            }
        }
        return null;
    }

    private void checkComponentName(String name) throws RoutingException {
        if (!this.componentName.equals(name)) {
            throw new RoutingException("This receiver is assigned to component: " + this.componentName + " but has received an event for component: " + name + ". Please check your config to make sure each component" + "has its own instance of IdempotentReceiver");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void load(String componentName) throws RoutingException {
        block9: {
            this.componentName = componentName;
            this.idStore = new File(this.storePath + "/muleComponent_" + componentName + ".store");
            if (this.disablePersistence) {
                return;
            }
            try {
                if (this.idStore.exists()) {
                    BufferedReader reader = null;
                    try {
                        String id;
                        reader = new BufferedReader(new FileReader(this.idStore));
                        while ((id = reader.readLine()) != null) {
                            this.messageIds.add(id);
                        }
                        break block9;
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                this.idStore = Utility.createFile(this.idStore.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RoutingException("Failed to load Idempotent receiver message id store from: " + this.idStore.getAbsolutePath() + ". " + e.getMessage(), e);
            }
        }
    }

    protected synchronized void storeId(Object id) throws RoutingException {
        this.messageIds.add(id);
        if (this.disablePersistence) {
            return;
        }
        try {
            Utility.stringToFile(this.idStore.getAbsolutePath(), id.toString(), true, true);
        }
        catch (IOException e) {
            throw new RoutingException("Failed to write message id: " + id + " to Idempotent receiver store at: " + this.idStore.getAbsolutePath() + ". " + e.getMessage(), e);
        }
    }

    public boolean isDisablePersistence() {
        return this.disablePersistence;
    }

    public void setDisablePersistence(boolean disablePersistence) {
        this.disablePersistence = disablePersistence;
    }

    public String getStorePath() {
        return this.storePath;
    }

    public void setStorePath(String storePath) {
        this.storePath = storePath == null ? DEFAULT_STORE_PATH : (storePath.endsWith("/") ? (storePath = storePath.substring(0, storePath.length() - 1)) : storePath);
    }
}

