/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.management.stats.RouterStatistics;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOFilter;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.routing.UMOInboundRouter;
import org.mule.umo.transformer.TransformerException;

public class SelectiveConsumer
implements UMOInboundRouter {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private UMOFilter filter;
    private boolean transformFirst = true;
    private RouterStatistics routerStatistics;

    public boolean isMatch(UMOEvent event) throws RoutingException {
        if (this.filter == null) {
            return true;
        }
        Object payload = null;
        if (this.transformFirst) {
            try {
                payload = event.getTransformedMessage();
            }
            catch (TransformerException e) {
                throw new RoutingException("Failed to transform message before applying the filter: " + e.getMessage(), e);
            }
        } else {
            payload = event.getMessage().getPayload();
        }
        return this.filter.accept(payload);
    }

    public UMOEvent[] process(UMOEvent event) throws RoutingException {
        if (this.isMatch(event)) {
            return new UMOEvent[]{event};
        }
        return null;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UMOFilter filter) {
        this.filter = filter;
    }

    public boolean isTransformFirst() {
        return this.transformFirst;
    }

    public void setTransformFirst(boolean transformFirst) {
        this.transformFirst = transformFirst;
    }

    public void setRouterStatistics(RouterStatistics stats) {
        this.routerStatistics = stats;
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }
}

