/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.Iterator;
import java.util.List;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.UniqueIdNotSupportedException;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutingException;

public abstract class AbstractMessageSplitter
extends FilteringOutboundRouter {
    protected boolean multimatch = true;

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        String correlationId = null;
        try {
            correlationId = message.getUniqueId();
        }
        catch (UniqueIdNotSupportedException e) {
            throw new RoutingException("Cannot use multicasting router with transports that do not support a unique id", e, message);
        }
        this.initialise(message);
        UMOMessage result = null;
        List list = this.getEndpoints();
        int i = 1;
        Iterator iterator = list.iterator();
        block4: while (iterator.hasNext()) {
            UMOEndpoint endpoint = (UMOEndpoint)iterator.next();
            if ((message = this.getMessagePart(message, endpoint)) == null) {
                this.logger.warn((Object)("Message part is null for endpoint: " + endpoint.getEndpointURI().toString()));
            }
            while (message != null) {
                try {
                    message.setCorrelationId(correlationId);
                    message.setCorrelationSequence(i++);
                    message.setCorrelationGroupSize(list.size());
                    if (synchronous) {
                        result = this.send(session, message, endpoint);
                    } else {
                        this.dispatch(session, message, endpoint);
                    }
                }
                catch (UMOException e) {
                    throw new CouldNotRouteOutboundMessageException(e.getMessage(), (Throwable)e, message);
                }
                if (!this.multimatch) continue block4;
                message = this.getMessagePart(message, endpoint);
            }
        }
        return result;
    }

    protected void initialise(UMOMessage message) {
    }

    protected abstract UMOMessage getMessagePart(UMOMessage var1, UMOEndpoint var2);
}

