/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.PropertyExtractor;
import org.mule.management.stats.RouterStatistics;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.UniqueIdNotSupportedException;
import org.mule.umo.routing.UMOOutboundRouter;

public abstract class AbstractOutboundRouter
implements UMOOutboundRouter {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected List endpoints = new CopyOnWriteArrayList();
    protected String replyTo = null;
    protected boolean correlationId = false;
    protected PropertyExtractor correlationIdExtractor = null;
    protected PropertyExtractor correlationSequenceExtractor = null;
    protected PropertyExtractor correlationGroupExtractor = null;
    protected RouterStatistics routerStatistics;

    public void dispatch(UMOSession session, UMOMessage message, UMOEndpoint endpoint) throws UMOException {
        this.setMessageProperties(session, message, endpoint);
        session.dispatchEvent(message, endpoint);
        if (this.routerStatistics != null && this.routerStatistics.isEnabled()) {
            this.routerStatistics.incrementRoutedMessage(endpoint);
        }
    }

    public UMOMessage send(UMOSession session, UMOMessage message, UMOEndpoint endpoint) throws UMOException {
        this.setMessageProperties(session, message, endpoint);
        if (this.replyTo != null) {
            this.dispatch(session, message, endpoint);
            return null;
        }
        UMOMessage result = session.sendEvent(message, endpoint);
        if (this.routerStatistics != null && this.routerStatistics.isEnabled()) {
            this.routerStatistics.incrementRoutedMessage(endpoint);
        }
        return result;
    }

    protected void setMessageProperties(UMOSession session, UMOMessage message, UMOEndpoint endpoint) throws UniqueIdNotSupportedException {
        if (this.replyTo != null) {
            message.setReplyTo(this.replyTo);
            message.setProperty("MULE_REPLYTO_REQUESTOR", session.getComponent().getDescriptor().getName());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Setting replyTo=" + this.replyTo + " for outbound endpoint: " + endpoint.getEndpointURI()));
            }
        }
        if (this.correlationId) {
            String correlation = null;
            if (this.correlationIdExtractor == null) {
                correlation = message.getUniqueId();
            } else {
                Object o = this.correlationIdExtractor.getPropertry("MULE_CORRELATION_ID", message);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Extracted correlation Id as: " + o));
                }
                correlation = o.toString();
            }
            int seq = 1;
            if (this.correlationSequenceExtractor != null) {
                Object o = this.correlationSequenceExtractor.getPropertry("MULE_CORRELATION_SEQUENCE", message);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Extracted correlation sequence as: " + o));
                }
                if (o != null) {
                    try {
                        seq = Integer.parseInt(o.toString());
                    }
                    catch (NumberFormatException e) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Invalid Correlation sequence value: " + o.toString() + ". Defaulting to 1"));
                        }
                        seq = 1;
                    }
                }
            }
            int group = 1;
            if (this.correlationGroupExtractor != null) {
                Object o = this.correlationGroupExtractor.getPropertry("MULE_CORRELATION_GROUP", message);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Extracted correlation Group size as: " + o));
                }
                if (o != null) {
                    try {
                        group = Integer.parseInt(o.toString());
                    }
                    catch (NumberFormatException e) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Invalid Correlation group value: " + o.toString() + ". Defaulting to 1"));
                        }
                        group = 1;
                    }
                }
            }
            if (this.logger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("Setting Correlation info form Outbound router for endpoint: ").append(endpoint.getEndpointURI());
                buf.append("\n").append("Id=").append(correlation);
                buf.append(", ").append("Seq=").append(seq);
                buf.append(", ").append("Group Size=").append(group);
                this.logger.debug((Object)buf.toString());
            }
            message.setCorrelationId(correlation);
            message.setCorrelationGroupSize(group);
            message.setCorrelationSequence(seq);
        }
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        this.endpoints = new CopyOnWriteArrayList((Collection)endpoints);
    }

    public void addEndpoint(UMOEndpoint endpoint) {
        endpoint.setType("sender");
        this.endpoints.add(endpoint);
    }

    public boolean removeEndpoint(UMOEndpoint endpoint) {
        return this.endpoints.remove(endpoint);
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo != null ? MuleManager.getInstance().lookupEndpointIdentifier(replyTo, replyTo) : null;
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }

    public void setRouterStatistics(RouterStatistics routerStatistics) {
        this.routerStatistics = routerStatistics;
    }

    public boolean isCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(boolean correlationId) {
        this.correlationId = correlationId;
    }

    public PropertyExtractor getCorrelationIdExtractor() {
        return this.correlationIdExtractor;
    }

    public void setCorrelationIdExtractor(PropertyExtractor correlationIdExtractor) {
        this.correlationIdExtractor = correlationIdExtractor;
    }

    public PropertyExtractor getCorrelationSequenceExtractor() {
        return this.correlationSequenceExtractor;
    }

    public void setCorrelationSequenceExtractor(PropertyExtractor correlationSequenceExtractor) {
        this.correlationSequenceExtractor = correlationSequenceExtractor;
    }

    public PropertyExtractor getCorrelationGroupExtractor() {
        return this.correlationGroupExtractor;
    }

    public void setCorrelationGroupExtractor(PropertyExtractor correlationGroupExtractor) {
        this.correlationGroupExtractor = correlationGroupExtractor;
    }
}

