/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.mule.routing.filters.MessageFilter;
import org.mule.routing.outbound.AbstractOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutingException;
import org.mule.umo.transformer.UMOTransformer;

public class FilteringOutboundRouter
extends AbstractOutboundRouter {
    private UMOTransformer transformer;
    private UMOFilter filter;

    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        UMOMessage result = null;
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutingException("No endpoints are set on this router, cannot route message");
        }
        try {
            if (synchronous) {
                result = this.send(session, message, (UMOEndpoint)this.endpoints.get(0));
            } else {
                this.dispatch(session, message, (UMOEndpoint)this.endpoints.get(0));
            }
        }
        catch (UMOException e) {
            throw new CouldNotRouteOutboundMessageException(e.getMessage(), (Throwable)e, message);
        }
        return result;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public void setFilter(UMOFilter filter) {
        this.filter = filter;
    }

    public boolean isMatch(UMOMessage message) throws RoutingException {
        if (this.getFilter() == null) {
            return true;
        }
        if (this.getFilter() instanceof MessageFilter) {
            return this.getFilter().accept(message);
        }
        try {
            Object payload = message.getPayload();
            if (this.transformer != null) {
                payload = this.transformer.transform(message);
            }
            return this.getFilter().accept(payload);
        }
        catch (Exception e) {
            throw new RoutingException("Failed to transform event payload: " + e, e);
        }
    }

    public UMOTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(UMOTransformer transformer) {
        this.transformer = transformer;
    }
}

