/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.List;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.UniqueIdNotSupportedException;
import org.mule.umo.routing.CouldNotRouteOutboundMessageException;
import org.mule.umo.routing.RoutingException;

public class MulticastingRouter
extends FilteringOutboundRouter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessage route(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        UMOMessage result = null;
        if (this.endpoints == null || this.endpoints.size() == 0) {
            throw new RoutingException("No endpoints are set on this router, cannot route message");
        }
        try {
            message.setCorrelationId(message.getUniqueId());
            message.setCorrelationGroupSize(this.endpoints.size());
        }
        catch (UniqueIdNotSupportedException e) {
            throw new RoutingException("Cannot use multicasting router with transports that do not support a unique id", e, message);
        }
        try {
            List list = this.endpoints;
            synchronized (list) {
                for (int i = 0; i < this.endpoints.size(); ++i) {
                    UMOEndpoint endpoint = (UMOEndpoint)this.endpoints.get(i);
                    if (synchronous) {
                        result = this.send(session, message, endpoint);
                        continue;
                    }
                    this.dispatch(session, message, endpoint);
                }
            }
        }
        catch (UMOException e) {
            throw new CouldNotRouteOutboundMessageException(e.getMessage(), (Throwable)e, message);
        }
        return result;
    }
}

