/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.routing.inbound.EventGroup;
import org.mule.routing.response.AbstractResponseRouter;
import org.mule.routing.response.ResponseTimeoutException;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.provider.UniqueIdNotSupportedException;
import org.mule.umo.routing.RoutingException;

public abstract class AbstractResponseAggregator
extends AbstractResponseRouter {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$routing$response$AbstractResponseAggregator == null ? (class$org$mule$routing$response$AbstractResponseAggregator = AbstractResponseAggregator.class$("org.mule.routing.response.AbstractResponseAggregator")) : class$org$mule$routing$response$AbstractResponseAggregator));
    private Map responseEvents = new ConcurrentHashMap();
    private Map locks = new ConcurrentHashMap();
    protected static final String NO_CORRELATION_ID = "no-id";
    protected long timeout = 0L;
    protected Map eventGroups = new ConcurrentHashMap();
    private Object lock = new Object();
    static /* synthetic */ Class class$org$mule$routing$response$AbstractResponseAggregator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(UMOEvent event) throws RoutingException {
        SynchronizedBoolean doAggregate = new SynchronizedBoolean(false);
        EventGroup eg = this.addEvent(event);
        doAggregate.commit(false, this.shouldAggregate(eg));
        if (doAggregate.get()) {
            Object object = this.lock;
            synchronized (object) {
                UMOMessage returnMessage = this.aggregateEvents(eg);
                String id = eg.getGroupId();
                this.removeGroup(id);
                this.responseEvents.put(id, returnMessage);
                Sync s = (Sync)this.locks.get(id);
                if (s == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Creating latch for " + id + " in " + this));
                    }
                    s = new Latch();
                    this.locks.put(id, s);
                }
                s.release();
            }
        }
    }

    protected EventGroup addEvent(UMOEvent event) {
        EventGroup eg;
        String cId = event.getMessage().getCorrelationId();
        if (cId == null) {
            cId = NO_CORRELATION_ID;
        }
        if ((eg = (EventGroup)this.eventGroups.get(cId)) == null) {
            eg = new EventGroup(cId);
            eg.addEvent(event);
            this.eventGroups.put(eg.getGroupId(), eg);
        } else {
            eg.addEvent(event);
        }
        return eg;
    }

    protected void removeGroup(String id) {
        this.eventGroups.remove(id);
    }

    public UMOMessage getResponse(UMOMessage message) throws RoutingException {
        String messageId = null;
        try {
            messageId = message.getUniqueId();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Waiting for response for message id: " + messageId + " in " + this));
            }
        }
        catch (UniqueIdNotSupportedException e) {
            throw new RoutingException("Failed to receive response for message id: " + e.getMessage(), e);
        }
        Sync s = (Sync)this.locks.get(messageId);
        if (s == null) {
            logger.debug((Object)("Creating latch for " + messageId + " in " + this));
            s = new Latch();
            this.locks.put(messageId, s);
        }
        boolean b = false;
        try {
            if (this.timeout >= 0L) {
                s.acquire();
                b = true;
            } else {
                b = s.attempt(this.timeout);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!b) {
            throw new ResponseTimeoutException("Response timed out waiting for message response id: " + messageId);
        }
        UMOMessage result = (UMOMessage)this.responseEvents.get(messageId);
        this.locks.remove(messageId);
        if (result == null) {
            throw new IllegalStateException("Response Message is null");
        }
        return result;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected abstract boolean shouldAggregate(EventGroup var1);

    protected abstract UMOMessage aggregateEvents(EventGroup var1) throws RoutingException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

