/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.List;
import java.util.Map;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.config.ThreadingProfile;
import org.mule.config.pool.CommonsPoolFactory;
import org.mule.impl.MuleDescriptor;
import org.mule.interceptors.LoggingInterceptor;
import org.mule.interceptors.TimerInterceptor;
import org.mule.providers.AbstractConnector;
import org.mule.routing.ForwardingCatchAllStrategy;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.filters.logic.AndFilter;
import org.mule.routing.inbound.IdempotentReceiver;
import org.mule.routing.inbound.SelectiveConsumer;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.tck.NamedTestCase;
import org.mule.tck.testmodels.mule.TestCatchAllStrategy;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.tck.testmodels.mule.TestDefaultLifecycleAdapterFactory;
import org.mule.tck.testmodels.mule.TestEntryPointResolver;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.tck.testmodels.mule.TestResponseAggregator;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.umo.UMOAgent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.model.UMOModel;
import org.mule.umo.routing.UMOInboundMessageRouter;
import org.mule.umo.routing.UMOInboundRouter;
import org.mule.umo.routing.UMOOutboundMessageRouter;
import org.mule.umo.routing.UMOOutboundRouter;
import org.mule.umo.routing.UMOResponseMessageRouter;
import org.mule.umo.routing.UMOResponseRouter;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.queue.SerialisationPersistence;

public abstract class AbstractConfigBuilderTestCase
extends NamedTestCase {
    protected static boolean initialised = false;
    static /* synthetic */ Class class$org$mule$impl$DefaultExceptionStrategy;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$mule$tck$testmodels$fruit$Orange;

    protected AbstractConfigBuilderTestCase() {
        try {
            if (MuleManager.isInstanciated()) {
                MuleManager.getInstance().dispose();
            }
        }
        catch (UMOException e) {
            AbstractConfigBuilderTestCase.fail((String)e.getMessage());
        }
        initialised = false;
    }

    protected void setUp() throws Exception {
        if (!initialised) {
            System.setProperty("org.mule.disable.server.connections", "true");
            if (MuleManager.isInstanciated()) {
                MuleManager.getInstance().dispose();
            }
            ConfigurationBuilder configBuilder = this.getConfigBuilder();
            configBuilder.configure(this.getConfigResource());
            initialised = true;
            System.setProperty("org.mule.disable.server.connections", "false");
        }
    }

    public void testManagerConfig() throws Exception {
        AbstractConfigBuilderTestCase.assertEquals((Object)"true", (Object)MuleManager.getInstance().getProperty("doCompression"));
        AbstractConfigBuilderTestCase.assertNotNull((Object)MuleManager.getInstance().getTransactionManager());
    }

    public void testConnectorConfig() throws Exception {
        TestConnector c = (TestConnector)MuleManager.getInstance().lookupConnector("dummyConnector");
        AbstractConfigBuilderTestCase.assertNotNull((Object)c);
        AbstractConfigBuilderTestCase.assertNotNull((Object)c.getExceptionStrategy());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(c.getExceptionStrategy() instanceof TestExceptionStrategy));
    }

    public void testGlobalEndpointConfig() {
        UMOEndpoint endpoint = MuleManager.getInstance().lookupEndpoint("fruitBowlEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)endpoint.getEndpointURI().getAddress(), (String)"fruitBowlPublishQ");
    }

    public void testEndpointConfig() {
        String endpointString = MuleManager.getInstance().lookupEndpointIdentifier("Test Queue", null);
        AbstractConfigBuilderTestCase.assertEquals((String)endpointString, (String)"test://test.queue");
        UMOEndpoint endpoint = MuleManager.getInstance().lookupEndpoint("waterMelonEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)"test.queue", (String)endpoint.getEndpointURI().getAddress());
        UMODescriptor descriptor = MuleManager.getInstance().getModel().getDescriptor("appleComponent2");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor);
    }

    public void testInterceptorStacks() {
        List stack = MuleManager.getInstance().lookupInterceptorStack("default");
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)stack.size());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(stack.get(0) instanceof LoggingInterceptor));
        AbstractConfigBuilderTestCase.assertTrue((boolean)(stack.get(1) instanceof TimerInterceptor));
    }

    public void testExceptionStrategy() {
        UMODescriptor descriptor = MuleManager.getInstance().getModel().getDescriptor("orangeComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)MuleManager.getInstance().getModel().getExceptionStrategy());
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getExceptionStrategy());
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getExceptionStrategy().getEndpoint());
        AbstractConfigBuilderTestCase.assertEquals((String)"test://orange.exceptions", (String)descriptor.getExceptionStrategy().getEndpoint().getEndpointURI().toString());
        descriptor = MuleManager.getInstance().getModel().getDescriptor("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getExceptionStrategy());
        AbstractConfigBuilderTestCase.assertEquals((Object)(class$org$mule$impl$DefaultExceptionStrategy == null ? (class$org$mule$impl$DefaultExceptionStrategy = AbstractConfigBuilderTestCase.class$("org.mule.impl.DefaultExceptionStrategy")) : class$org$mule$impl$DefaultExceptionStrategy), descriptor.getExceptionStrategy().getClass());
    }

    public void testTransformerConfig() {
        UMOTransformer t = MuleManager.getInstance().lookupTransformer("TestCompressionTransformer");
        AbstractConfigBuilderTestCase.assertNotNull((Object)t);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        AbstractConfigBuilderTestCase.assertEquals((Object)t.getReturnClass(), (Object)(class$java$lang$String == null ? (class$java$lang$String = AbstractConfigBuilderTestCase.class$("java.lang.String")) : class$java$lang$String));
        AbstractConfigBuilderTestCase.assertNotNull((Object)((TestCompressionTransformer)t).getContainerProperty());
    }

    public void testModelConfig() throws Exception {
        UMOModel model = MuleManager.getInstance().getModel();
        AbstractConfigBuilderTestCase.assertNotNull((Object)model);
        AbstractConfigBuilderTestCase.assertEquals((String)"test-model", (String)model.getName());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(model.getEntryPointResolver() instanceof TestEntryPointResolver));
        AbstractConfigBuilderTestCase.assertTrue((boolean)(model.getExceptionStrategy() instanceof TestExceptionStrategy));
        AbstractConfigBuilderTestCase.assertNotNull((Object)model.getExceptionStrategy().getEndpoint());
        AbstractConfigBuilderTestCase.assertEquals((String)"test://component.exceptions", (String)model.getExceptionStrategy().getEndpoint().getEndpointURI().toString());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(model.getLifecycleAdapterFactory() instanceof TestDefaultLifecycleAdapterFactory));
        AbstractConfigBuilderTestCase.assertTrue((boolean)model.isComponentRegistered("orangeComponent"));
        AbstractConfigBuilderTestCase.assertTrue((boolean)model.isComponentRegistered("appleComponent"));
        AbstractConfigBuilderTestCase.assertTrue((boolean)model.isComponentRegistered("appleComponent2"));
    }

    public void testPropertiesConfig() throws Exception {
        UMODescriptor descriptor = MuleManager.getInstance().getModel().getDescriptor("orangeComponent");
        Map props = descriptor.getProperties();
        AbstractConfigBuilderTestCase.assertNotNull((Object)props);
        AbstractConfigBuilderTestCase.assertEquals((Object)"9", props.get("segments"));
        AbstractConfigBuilderTestCase.assertEquals((Object)"4.21", props.get("radius"));
        AbstractConfigBuilderTestCase.assertEquals((Object)"Juicy Baby!", props.get("brand"));
        AbstractConfigBuilderTestCase.assertNotNull(props.get("listProperties"));
        List list = (List)props.get("listProperties");
        AbstractConfigBuilderTestCase.assertEquals((int)3, (int)list.size());
        AbstractConfigBuilderTestCase.assertEquals((Object)"prop1", list.get(0));
        AbstractConfigBuilderTestCase.assertEquals((Object)"prop2", list.get(1));
        AbstractConfigBuilderTestCase.assertEquals((Object)"prop3", list.get(2));
        AbstractConfigBuilderTestCase.assertNotNull(props.get("arrayProperties"));
        list = (List)props.get("arrayProperties");
        AbstractConfigBuilderTestCase.assertEquals((int)3, (int)list.size());
        AbstractConfigBuilderTestCase.assertEquals((Object)"prop4", list.get(0));
        AbstractConfigBuilderTestCase.assertEquals((Object)"prop5", list.get(1));
        AbstractConfigBuilderTestCase.assertEquals((Object)"prop6", list.get(2));
        AbstractConfigBuilderTestCase.assertNotNull(props.get("mapProperties"));
        props = (Map)props.get("mapProperties");
        AbstractConfigBuilderTestCase.assertEquals((Object)"prop1", props.get("prop1"));
        AbstractConfigBuilderTestCase.assertEquals((Object)"prop2", props.get("prop2"));
        descriptor = MuleManager.getInstance().getModel().getDescriptor("orangeComponent");
        AbstractConfigBuilderTestCase.assertEquals((int)7, (int)descriptor.getProperties().size());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)descriptor.getInboundRouter().getEndpoints().size());
    }

    public void testOutboundRouterConfig() {
        UMODescriptor descriptor = MuleManager.getInstance().getModel().getDescriptor("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getOutboundRouter());
        UMOOutboundMessageRouter router = descriptor.getOutboundRouter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)router.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)router.getRouters().size());
        UMOOutboundRouter route1 = (UMOOutboundRouter)router.getRouters().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(route1 instanceof FilteringOutboundRouter));
        AbstractConfigBuilderTestCase.assertNotNull((Object)((FilteringOutboundRouter)route1).getTransformer());
        UMOFilter filter = ((FilteringOutboundRouter)route1).getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        AbstractConfigBuilderTestCase.assertEquals((Object)(class$java$lang$String == null ? (class$java$lang$String = AbstractConfigBuilderTestCase.class$("java.lang.String")) : class$java$lang$String), (Object)((PayloadTypeFilter)filter).getExpectedType());
        UMOOutboundRouter route2 = (UMOOutboundRouter)router.getRouters().get(1);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(route2 instanceof FilteringOutboundRouter));
        UMOFilter filter2 = ((FilteringOutboundRouter)route2).getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter2);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter2 instanceof AndFilter));
        UMOFilter left = ((AndFilter)filter2).getLeftFilter();
        UMOFilter right = ((AndFilter)filter2).getRightFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)left);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(left instanceof RegExFilter));
        AbstractConfigBuilderTestCase.assertEquals((String)"the quick brown (.*)", (String)((RegExFilter)left).getPattern());
        AbstractConfigBuilderTestCase.assertNotNull((Object)right);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(right instanceof RegExFilter));
        AbstractConfigBuilderTestCase.assertEquals((String)"(.*) brown (.*)", (String)((RegExFilter)right).getPattern());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router.getCatchAllStrategy() instanceof TestCatchAllStrategy));
    }

    public void testDescriptorEndpoints() {
        UMODescriptor descriptor = MuleManager.getInstance().getModel().getDescriptor("orangeComponent");
        AbstractConfigBuilderTestCase.assertEquals((int)1, (int)descriptor.getOutboundRouter().getRouters().size());
        UMOOutboundRouter router = (UMOOutboundRouter)descriptor.getOutboundRouter().getRouters().get(0);
        AbstractConfigBuilderTestCase.assertEquals((int)1, (int)router.getEndpoints().size());
        UMOEndpoint endpoint = (UMOEndpoint)router.getEndpoints().get(0);
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)"appleInEndpoint", (String)endpoint.getName());
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint.getTransformer());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(endpoint.getTransformer() instanceof TestCompressionTransformer));
        endpoint = MuleManager.getInstance().lookupEndpoint("appleInEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertNull((Object)endpoint.getTransformer());
        endpoint = descriptor.getInboundEndpoint();
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)descriptor.getInboundRouter().getEndpoints().size());
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getInboundRouter().getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(descriptor.getInboundRouter().getCatchAllStrategy() instanceof ForwardingCatchAllStrategy));
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getInboundRouter().getCatchAllStrategy().getEndpoint());
        AbstractConfigBuilderTestCase.assertEquals((String)"test://catch.all", (String)descriptor.getInboundRouter().getCatchAllStrategy().getEndpoint().getEndpointURI().toString());
        endpoint = descriptor.getInboundRouter().getEndpoint("orangeEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)"orangeEndpoint", (String)endpoint.getName());
        AbstractConfigBuilderTestCase.assertEquals((String)"orangeQ", (String)endpoint.getEndpointURI().getAddress());
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint.getTransformer());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(endpoint.getTransformer() instanceof TestCompressionTransformer));
        endpoint = MuleManager.getInstance().lookupEndpoint("orangeEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertNull((Object)endpoint.getTransformer());
    }

    public void testInboundRouterConfig() {
        UMODescriptor descriptor = MuleManager.getInstance().getModel().getDescriptor("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getInboundRouter());
        UMOInboundMessageRouter messageRouter = descriptor.getInboundRouter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getRouters().size());
        UMOInboundRouter router = (UMOInboundRouter)messageRouter.getRouters().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router instanceof SelectiveConsumer));
        SelectiveConsumer sc = (SelectiveConsumer)router;
        AbstractConfigBuilderTestCase.assertNotNull((Object)sc.getFilter());
        UMOFilter filter = sc.getFilter();
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        AbstractConfigBuilderTestCase.assertEquals((Object)(class$java$lang$String == null ? (class$java$lang$String = AbstractConfigBuilderTestCase.class$("java.lang.String")) : class$java$lang$String), (Object)((PayloadTypeFilter)filter).getExpectedType());
        UMOInboundRouter router2 = (UMOInboundRouter)messageRouter.getRouters().get(1);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router2 instanceof IdempotentReceiver));
    }

    public void testResponseRouterConfig() {
        UMODescriptor descriptor = MuleManager.getInstance().getModel().getDescriptor("orangeComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)descriptor.getResponseRouter());
        UMOResponseMessageRouter messageRouter = descriptor.getResponseRouter();
        AbstractConfigBuilderTestCase.assertNull((Object)messageRouter.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertNotNull((Object)messageRouter.getTransformer());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(messageRouter.getTransformer() instanceof TestCompressionTransformer));
        AbstractConfigBuilderTestCase.assertEquals((int)1, (int)messageRouter.getRouters().size());
        UMOResponseRouter router = (UMOResponseRouter)messageRouter.getRouters().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router instanceof TestResponseAggregator));
        AbstractConfigBuilderTestCase.assertNotNull((Object)messageRouter.getEndpoints());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getEndpoints().size());
        UMOEndpoint ep = (UMOEndpoint)messageRouter.getEndpoints().get(0);
        AbstractConfigBuilderTestCase.assertEquals((String)"response1", (String)ep.getEndpointURI().getAddress());
        AbstractConfigBuilderTestCase.assertEquals((String)"response", (String)ep.getType());
        ep = (UMOEndpoint)messageRouter.getEndpoints().get(1);
        AbstractConfigBuilderTestCase.assertEquals((String)"AppleResponseQueue", (String)ep.getEndpointURI().getAddress());
        AbstractConfigBuilderTestCase.assertEquals((String)"response", (String)ep.getType());
    }

    public void testThreadingConfig() throws MuleException {
        ThreadingProfile tp = MuleManager.getConfiguration().getDefaultThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)0, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)8, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)4, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)0, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)60001L, (long)tp.getThreadTTL());
        tp = MuleManager.getConfiguration().getComponentThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)0, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)8, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)4, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)0, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)60001L, (long)tp.getThreadTTL());
        AbstractConnector c = (AbstractConnector)MuleManager.getInstance().lookupConnector("dummyConnector");
        tp = c.getDispatcherThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)10, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)10, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)4, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)-1L, (long)tp.getThreadTTL());
        MuleDescriptor descriptor = (MuleDescriptor)MuleManager.getInstance().getModel().getDescriptor("appleComponent2");
        tp = descriptor.getThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)6, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)12, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)6, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)4, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)-1L, (long)tp.getThreadTTL());
    }

    public void testPoolingConfig() {
        PoolingProfile pp = MuleManager.getConfiguration().getPoolingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)8, (int)pp.getMaxActive());
        AbstractConfigBuilderTestCase.assertEquals((int)4, (int)pp.getMaxIdle());
        AbstractConfigBuilderTestCase.assertEquals((long)4000L, (long)pp.getMaxWait());
        AbstractConfigBuilderTestCase.assertEquals((byte)2, (byte)pp.getExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((int)1, (int)pp.getInitialisationPolicy());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(pp.getPoolFactory() instanceof CommonsPoolFactory));
        MuleDescriptor descriptor = (MuleDescriptor)MuleManager.getInstance().getModel().getDescriptor("appleComponent2");
        pp = descriptor.getPoolingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)5, (int)pp.getMaxActive());
        AbstractConfigBuilderTestCase.assertEquals((int)5, (int)pp.getMaxIdle());
        AbstractConfigBuilderTestCase.assertEquals((long)4000L, (long)pp.getMaxWait());
        AbstractConfigBuilderTestCase.assertEquals((byte)2, (byte)pp.getExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)pp.getInitialisationPolicy());
    }

    public void testQueueProfileConfig() {
        QueueProfile qp = MuleManager.getConfiguration().getQueueProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)100, (int)qp.getMaxOutstandingMessages());
        AbstractConfigBuilderTestCase.assertNotNull((Object)qp.getPersistenceStrategy());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(qp.getPersistenceStrategy() instanceof SerialisationPersistence));
        MuleDescriptor descriptor = (MuleDescriptor)MuleManager.getInstance().getModel().getDescriptor("orangeComponent");
        qp = descriptor.getQueueProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)100, (int)qp.getMaxOutstandingMessages());
        AbstractConfigBuilderTestCase.assertNotNull((Object)qp.getPersistenceStrategy());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(qp.getPersistenceStrategy() instanceof SerialisationPersistence));
        descriptor = (MuleDescriptor)MuleManager.getInstance().getModel().getDescriptor("appleComponent2");
        qp = descriptor.getQueueProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)102, (int)qp.getMaxOutstandingMessages());
        AbstractConfigBuilderTestCase.assertNull((Object)qp.getPersistenceStrategy());
    }

    public void testEndpointProperties() throws Exception {
        UMODescriptor descriptor = MuleManager.getInstance().getModel().getDescriptor("appleComponent2");
        UMOEndpoint inEndpoint = descriptor.getInboundRouter().getEndpoint("transactedInboundEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint);
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint.getProperties());
        AbstractConfigBuilderTestCase.assertEquals((Object)"Prop1", inEndpoint.getProperties().get("testEndpointProperty"));
    }

    public void testTranactionConfig() throws Exception {
        UMODescriptor descriptor = MuleManager.getInstance().getModel().getDescriptor("appleComponent2");
        UMOEndpoint inEndpoint = descriptor.getInboundRouter().getEndpoint("transactedInboundEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint);
        AbstractConfigBuilderTestCase.assertNull((Object)descriptor.getOutboundEndpoint());
        AbstractConfigBuilderTestCase.assertEquals((int)1, (int)descriptor.getOutboundRouter().getRouters().size());
        UMOEndpoint outEndpoint = (UMOEndpoint)((UMOOutboundRouter)descriptor.getOutboundRouter().getRouters().get(0)).getEndpoints().get(0);
        AbstractConfigBuilderTestCase.assertNotNull((Object)outEndpoint);
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint.getTransactionConfig());
        AbstractConfigBuilderTestCase.assertEquals((byte)1, (byte)inEndpoint.getTransactionConfig().getBeginAction());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(inEndpoint.getTransactionConfig().getFactory() instanceof TestTransactionFactory));
        AbstractConfigBuilderTestCase.assertNull((Object)inEndpoint.getTransactionConfig().getConstraint());
    }

    public void testObjectReferences() throws UMOException {
        MuleDescriptor descriptor = (MuleDescriptor)MuleManager.getInstance().getModel().getDescriptor("orangeComponent");
        AbstractConfigBuilderTestCase.assertEquals((Object)"local:orange", (Object)descriptor.getImplementation());
        AbstractConfigBuilderTestCase.assertNotNull(descriptor.getProperties().get("orange"));
        AbstractConfigBuilderTestCase.assertEquals((Object)(class$org$mule$tck$testmodels$fruit$Orange == null ? (class$org$mule$tck$testmodels$fruit$Orange = AbstractConfigBuilderTestCase.class$("org.mule.tck.testmodels.fruit.Orange")) : class$org$mule$tck$testmodels$fruit$Orange), (Object)descriptor.getImplementationClass());
    }

    public void testAgentConfiguration() throws UMOException {
        UMOAgent agent = MuleManager.getInstance().removeAgent("jmxAgent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)agent);
    }

    public void testEnvironmentProperties() {
        Map props = MuleManager.getInstance().getProperties();
        AbstractConfigBuilderTestCase.assertNotNull((Object)props);
        AbstractConfigBuilderTestCase.assertNotNull(props.get("doCompression"));
        AbstractConfigBuilderTestCase.assertEquals((Object)"true", props.get("doCompression"));
        AbstractConfigBuilderTestCase.assertNotNull(props.get("beanProperty1"));
        AbstractConfigBuilderTestCase.assertEquals((Object)"this was set from the manager properties!", props.get("beanProperty1"));
        AbstractConfigBuilderTestCase.assertNotNull(props.get("OS Version"));
    }

    public void testTearDown() throws Exception {
        if (MuleManager.isInstanciated()) {
            MuleManager.getInstance().dispose();
        }
        initialised = false;
    }

    public abstract String getConfigResource();

    public abstract ConfigurationBuilder getConfigBuilder();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

