/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.providers;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.HashMap;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractConnector;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOExceptionStrategy;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageDispatcher;

public abstract class AbstractConnectorTestCase
extends AbstractMuleTestCase {
    protected MuleDescriptor descriptor;
    protected UMOConnector connector;
    static /* synthetic */ Class class$org$mule$tck$testmodels$fruit$Orange;
    static /* synthetic */ Class class$org$mule$umo$UMOExceptionStrategy;

    protected void setUp() throws Exception {
        super.setUp();
        this.descriptor = AbstractConnectorTestCase.getTestDescriptor("orange", (class$org$mule$tck$testmodels$fruit$Orange == null ? (class$org$mule$tck$testmodels$fruit$Orange = AbstractConnectorTestCase.class$("org.mule.tck.testmodels.fruit.Orange")) : class$org$mule$tck$testmodels$fruit$Orange).getName());
        this.connector = this.getConnector();
    }

    protected void tearDown() throws Exception {
        if (!this.connector.isDisposed()) {
            this.connector.dispose();
        }
    }

    public void testConnectorExceptionHandling() throws Exception {
        AbstractConnectorTestCase.assertNotNull((Object)this.connector);
        Mock ehandlerMock = new Mock(class$org$mule$umo$UMOExceptionStrategy == null ? (class$org$mule$umo$UMOExceptionStrategy = AbstractConnectorTestCase.class$("org.mule.umo.UMOExceptionStrategy")) : class$org$mule$umo$UMOExceptionStrategy, "exceptionHandler");
        ehandlerMock.expect("handleException", C.ANY_ARGS);
        AbstractConnectorTestCase.assertNotNull((Object)this.connector.getExceptionStrategy());
        this.connector.setExceptionStrategy((UMOExceptionStrategy)ehandlerMock.proxy());
        this.connector.handleException("Dummy exception", new MuleException("Dummy"));
        if (this.connector instanceof AbstractConnector) {
            ehandlerMock.expect("handleException", C.ANY_ARGS);
            ((AbstractConnector)this.connector).exceptionThrown(new MuleException("Dummy"));
        }
        ehandlerMock.verify();
        this.connector.setExceptionStrategy(null);
        try {
            this.connector.handleException("Dummy exception", new MuleException("Dummy"));
            AbstractConnectorTestCase.fail((String)"Should have thrown exception as no strategy is set");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testConnectorLifecycle() throws Exception {
        AbstractConnectorTestCase.assertNotNull((Object)this.connector);
        AbstractConnectorTestCase.assertTrue((!this.connector.isStarted() ? 1 : 0) != 0);
        AbstractConnectorTestCase.assertTrue((!this.connector.isDisposed() ? 1 : 0) != 0);
        this.connector.start();
        AbstractConnectorTestCase.assertTrue((boolean)this.connector.isStarted());
        AbstractConnectorTestCase.assertTrue((!this.connector.isDisposed() ? 1 : 0) != 0);
        this.connector.stop();
        AbstractConnectorTestCase.assertTrue((!this.connector.isStarted() ? 1 : 0) != 0);
        AbstractConnectorTestCase.assertTrue((!this.connector.isDisposed() ? 1 : 0) != 0);
        this.connector.dispose();
        AbstractConnectorTestCase.assertTrue((!this.connector.isStarted() ? 1 : 0) != 0);
        AbstractConnectorTestCase.assertTrue((boolean)this.connector.isDisposed());
        try {
            this.connector.start();
            AbstractConnectorTestCase.fail((String)"Connector cannot be restarted after being disposing");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConnectorListenerSupport() throws Exception {
        AbstractConnectorTestCase.assertNotNull((Object)this.connector);
        MuleDescriptor d = AbstractConnectorTestCase.getTestDescriptor("anOrange", (class$org$mule$tck$testmodels$fruit$Orange == null ? (class$org$mule$tck$testmodels$fruit$Orange = AbstractConnectorTestCase.class$("org.mule.tck.testmodels.fruit.Orange")) : class$org$mule$tck$testmodels$fruit$Orange).getName());
        UMOComponent component = MuleManager.getInstance().getModel().registerComponent(d);
        MuleEndpoint endpoint = new MuleEndpoint("test", new MuleEndpointURI(this.getTestEndpointURI()), this.connector, null, "sender", null);
        try {
            this.connector.registerListener(null, null);
            AbstractConnectorTestCase.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connector.registerListener(null, endpoint);
            AbstractConnectorTestCase.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connector.registerListener(component, null);
            AbstractConnectorTestCase.fail((String)"cannot register null");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.connector.registerListener(component, endpoint);
        this.connector.unregisterListener(component, endpoint);
        try {
            this.connector.unregisterListener(null, null);
            AbstractConnectorTestCase.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connector.unregisterListener(component, null);
            AbstractConnectorTestCase.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connector.unregisterListener(null, endpoint);
            AbstractConnectorTestCase.fail((String)"cannot unregister null");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.connector.unregisterListener(component, endpoint);
        MuleManager.getInstance().getModel().unregisterComponent(d);
    }

    public void testConnectorBeanProps() throws Exception {
        AbstractConnectorTestCase.assertNotNull((Object)this.connector);
        try {
            this.connector.setName(null);
            AbstractConnectorTestCase.fail((String)"Should throw IllegalArgumentException if name set to null");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.connector.setName("Test");
        AbstractConnectorTestCase.assertEquals((String)"Test", (String)this.connector.getName());
        AbstractConnectorTestCase.assertNotNull((String)"Protocol must be set as a constant", (Object)this.connector.getProtocol());
        AbstractConnector tempCnn = null;
        HashMap props = new HashMap();
        if (this.connector instanceof AbstractConnector) {
            tempCnn = (AbstractConnector)this.connector;
            tempCnn.setRetryFrequency(-1L);
            AbstractConnectorTestCase.assertEquals((long)1000L, (long)tempCnn.getRetryFrequency());
            tempCnn.setRetryCount(-1);
            AbstractConnectorTestCase.assertEquals((int)3, (int)tempCnn.getRetryCount());
        }
    }

    public void testConnectorMessageAdapter() throws Exception {
        UMOConnector connector = this.getConnector();
        AbstractConnectorTestCase.assertNotNull((Object)connector);
        UMOMessageAdapter adapter = connector.getMessageAdapter(this.getValidMessage());
        AbstractConnectorTestCase.assertNotNull((Object)adapter);
    }

    public void testConnectorMessageDispatcher() throws Exception {
        UMOConnector connector = this.getConnector();
        AbstractConnectorTestCase.assertNotNull((Object)connector);
        AbstractConnectorTestCase.assertNotNull((Object)connector.getDispatcherFactory());
        UMOMessageDispatcher dispatcher = connector.getDispatcher("dummy");
        AbstractConnectorTestCase.assertNotNull((Object)dispatcher);
        AbstractConnectorTestCase.assertEquals((Object)connector, (Object)dispatcher.getConnector());
    }

    public void testConnectorInitialise() throws Exception {
        UMOConnector connector = this.getConnector();
        try {
            connector.initialise();
            AbstractConnectorTestCase.fail((String)"A connector cannot be initialised more than once");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract UMOConnector getConnector() throws Exception;

    public abstract Object getValidMessage() throws Exception;

    public abstract String getTestEndpointURI();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

