/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOTransaction;
import org.mule.umo.UMOTransactionException;

public abstract class AbstractTransaction
implements UMOTransaction {
    protected final transient Log logger = LogFactory.getLog(this.getClass());

    public boolean isRollbackOnly() throws UMOTransactionException {
        return this.getStatus() == 1;
    }

    public boolean isBegun() throws UMOTransactionException {
        int status = this.getStatus();
        return status != 6 && status != 5;
    }

    public boolean isRolledBack() throws UMOTransactionException {
        return this.getStatus() == 4;
    }

    public boolean isCommitted() throws UMOTransactionException {
        return this.getStatus() == 3;
    }

    public void begin() throws UMOTransactionException {
        this.logger.debug((Object)"Beginning transaction");
        this.doBegin();
        TransactionCoordination.getInstance().bindTransaction(this);
    }

    public void commit() throws UMOTransactionException {
        this.logger.debug((Object)"Committing transaction");
        if (this.isRollbackOnly()) {
            throw new IllegalTransactionStateException("Transaction is marked for rollback");
        }
        this.doCommit();
        TransactionCoordination.getInstance().unbindTransaction(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws UMOTransactionException {
        try {
            this.logger.debug((Object)"Rolling back transaction");
            this.setRollbackOnly();
            this.doRollback();
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(this);
        }
    }

    protected abstract void doBegin() throws UMOTransactionException;

    protected abstract void doCommit() throws UMOTransactionException;

    protected abstract void doRollback() throws UMOTransactionException;
}

