/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.umo.UMOTransaction;
import org.mule.umo.UMOTransactionException;

public class TransactionCoordination {
    protected static final transient Log logger = LogFactory.getLog((Class)(class$org$mule$transaction$TransactionCoordination == null ? (class$org$mule$transaction$TransactionCoordination = TransactionCoordination.class$("org.mule.transaction.TransactionCoordination")) : class$org$mule$transaction$TransactionCoordination));
    private static TransactionCoordination instance;
    private int txCounter = 0;
    private ThreadLocal transactions = new ThreadLocal();
    static /* synthetic */ Class class$org$mule$transaction$TransactionCoordination;

    private TransactionCoordination() {
    }

    public static TransactionCoordination getInstance() {
        if (instance == null) {
            instance = new TransactionCoordination();
        }
        return instance;
    }

    public static void setInstance(TransactionCoordination txSync) throws IllegalStateException {
        if (instance != null && TransactionCoordination.instance.txCounter != 0) {
            throw new IllegalStateException("there are currently " + TransactionCoordination.instance.txCounter + "transactions associated with this manager, cannot replace the manager");
        }
        instance = txSync;
    }

    public UMOTransaction getTransaction() {
        return (UMOTransaction)this.transactions.get();
    }

    public void unbindTransaction(UMOTransaction transaction) throws UMOTransactionException {
        UMOTransaction oldTx = (UMOTransaction)this.transactions.get();
        if (oldTx != transaction) {
            throw new IllegalTransactionStateException("Trying to unbind an unbounded transaction");
        }
        this.transactions.set(null);
        this.decrementCounter();
    }

    public void bindTransaction(UMOTransaction transaction) throws UMOTransactionException {
        UMOTransaction oldTx = (UMOTransaction)this.transactions.get();
        if (oldTx != null) {
            throw new IllegalTransactionStateException("A transaction is already bound to the current thread");
        }
        this.transactions.set(transaction);
        this.incrementCounter();
        logger.debug((Object)("Binding new transaction (" + this.txCounter + ")"));
    }

    private synchronized void decrementCounter() {
        if (this.txCounter > 0) {
            --this.txCounter;
        }
    }

    private synchronized void incrementCounter() {
        ++this.txCounter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

