/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCallback;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOTransaction;
import org.mule.umo.UMOTransactionConfig;

public class TransactionTemplate {
    private static final transient Log logger = LogFactory.getLog((Class)(class$org$mule$transaction$TransactionTemplate == null ? (class$org$mule$transaction$TransactionTemplate = TransactionTemplate.class$("org.mule.transaction.TransactionTemplate")) : class$org$mule$transaction$TransactionTemplate));
    private UMOTransactionConfig config;
    static /* synthetic */ Class class$org$mule$transaction$TransactionTemplate;

    public TransactionTemplate(UMOTransactionConfig config) {
        this.config = config;
    }

    public Object execute(TransactionCallback callback) throws Exception {
        if (this.config == null) {
            return callback.doInTransaction();
        }
        byte action = this.config.getBeginAction();
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (action == 0 && tx != null) {
            throw new IllegalTransactionStateException("A transaction is available for this session, but transaction action is none");
        }
        if (action == 1 && tx != null) {
            throw new IllegalTransactionStateException("A transaction is available for this session, but transaction action is always begin");
        }
        if (action == 3 && tx == null) {
            throw new IllegalTransactionStateException("A transaction is not available for this session, but transaction action is always join");
        }
        if (action == 1 || action == 2) {
            logger.info((Object)"Beginning transaction");
            tx = this.config.getFactory().beginTransaction();
            logger.info((Object)"Transaction successfully started");
        } else {
            tx = null;
        }
        try {
            Object result = callback.doInTransaction();
            if (tx != null) {
                if (tx.isRollbackOnly()) {
                    logger.info((Object)"Transaction is marked for rollback");
                    tx.rollback();
                } else {
                    logger.info((Object)"Committing transaction");
                    tx.commit();
                }
            }
            return result;
        }
        catch (Exception e) {
            if (tx != null) {
                logger.info((Object)"Exception caught: rollback transaction", (Throwable)e);
                tx.rollback();
            }
            throw e;
        }
        catch (Error e) {
            if (tx != null) {
                logger.info((Object)"Error caught: rollback transaction", (Throwable)e);
                tx.rollback();
            }
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

