/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transaction;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.mule.MuleManager;
import org.mule.transaction.AbstractTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionRollbackException;
import org.mule.transaction.TransactionStatusException;
import org.mule.umo.UMOTransaction;
import org.mule.umo.UMOTransactionException;

public class XaTransaction
extends AbstractTransaction
implements UMOTransaction {
    private Transaction transaction = null;
    private Map resources = null;

    protected void doBegin() throws UMOTransactionException {
        TransactionManager txManager = MuleManager.getInstance().getTransactionManager();
        if (txManager == null) {
            throw new IllegalStateException("A transaction manager must be set on the Mule Manager");
        }
        try {
            txManager.begin();
            this.transaction = txManager.getTransaction();
        }
        catch (Exception e) {
            throw new UMOTransactionException("Can not start xa transaction", e);
        }
    }

    protected void doCommit() throws UMOTransactionException {
        try {
            this.transaction.commit();
        }
        catch (RollbackException e) {
            throw new TransactionRollbackException("transaction has already been marked for rollback", e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionRollbackException("transaction has already been marked for rollback", e);
        }
        catch (Exception e) {
            throw new IllegalTransactionStateException("Transaction could not be committed: " + e, e);
        }
    }

    protected void doRollback() throws TransactionRollbackException {
        try {
            this.transaction.rollback();
        }
        catch (SystemException e) {
            throw new TransactionRollbackException("Failed to roll back: " + e.getMessage(), e);
        }
    }

    public int getStatus() throws TransactionStatusException {
        if (this.transaction == null) {
            return 6;
        }
        try {
            return this.transaction.getStatus();
        }
        catch (SystemException e) {
            throw new TransactionStatusException("Unable to read transaction state: " + e.getMessage(), e);
        }
    }

    public void setRollbackOnly() {
        try {
            this.transaction.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Failed to set transaction to rollback only: " + e.getMessage());
        }
    }

    public Object getResource(Object key) {
        return this.resources == null ? null : this.resources.get(key);
    }

    public boolean hasResource(Object key) {
        return this.resources != null && this.resources.containsKey(key);
    }

    public void bindResource(Object key, Object resource) throws UMOTransactionException {
        if (this.resources == null) {
            this.resources = new HashMap();
        }
        if (this.resources.containsKey(key)) {
            throw new IllegalTransactionStateException("A resource has already been enlisted for key: " + key);
        }
        this.resources.put(key, resource);
    }
}

